{*
 * Product recurring plan selector template
 * Shows dropdown menu for selecting recurring payment plan on product page
 *}

{* Hidden field to store selected plan ID for form submission - always present *}
<input
    type="hidden"
    name="mtborica_recurring_plan_id"
    id="mtborica_recurring_plan_id_{$product_id|intval}"
    value="0"
/>

{* Only show selector if product has recurring plans *}
{if isset($has_recurring_plans) && $has_recurring_plans}
<div
    class="mtborica-recurring-selector"
    data-product-id="{$product_id|intval}"
>
    <div class="form-group">
        <label
            for="mtborica_recurring_plan_select_{$product_id|intval}"
            class="form-control-label"
        >
            {l s='Choose a Recurring Payment Plan' mod='mtborica'}
            <span
                class="mtborica-tooltip-trigger"
                data-toggle="tooltip"
                data-placement="top"
                title="{l s='Select a recurring payment plan if you want to pay for this product in intervals (e.g. monthly, quarterly, etc.).' mod='mtborica'}"
                aria-label="{l s='Select a recurring payment plan if you want to pay for this product in intervals (e.g. monthly, quarterly, etc.).' mod='mtborica'}"
            >
                ?
            </span>
        </label>
        <select
            name="mtborica_recurring_plan"
            id="mtborica_recurring_plan_select_{$product_id|intval}"
            class="form-control form-control-select"
        >
            <option value="0">{l s='No recurring payment' mod='mtborica'}</option>
            {if isset($recurring_plans) && !empty($recurring_plans)}
                {foreach from=$recurring_plans item=plan}
                    <option
                        value="{$plan.id|intval}"
                        data-plan-name="{$plan.name|escape:'html':'UTF-8'}"
                        data-plan-frequency="{$plan.formatted_frequency|escape:'html':'UTF-8'}"
                        data-plan-duration="{$plan.formatted_duration|escape:'html':'UTF-8'}"
                    >
                        {$plan.name|escape:'html':'UTF-8'}
                    </option>
                {/foreach}
            {/if}
        </select>
    </div>
</div>
{/if}

<style>
    .mtborica-tooltip-trigger {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        width: 20px;
        height: 20px;
        margin-left: 6px;
        border-radius: 50%;
        background-color: #007bff;
        color: #fff;
        font-weight: bold;
        font-size: 12px;
        line-height: 1;
        cursor: pointer;
    }

    .mtborica-tooltip-trigger:hover {
        background-color: #0056b3;
    }
</style>

<script type="text/javascript">
    (function() {
            var tooltipElements = document.querySelectorAll('[data-toggle="tooltip"]');
            if (tooltipElements.length) {
                if (window.jQuery && typeof window.jQuery.fn.tooltip === 'function') {
                    window.jQuery(tooltipElements).tooltip({ldelim}trigger: 'hover focus'{rdelim});
                } else if (typeof bootstrap !== 'undefined' && bootstrap.Tooltip) {
                    Array.prototype.slice.call(tooltipElements).forEach(function(element) {
                        new bootstrap.Tooltip(element);
                    });
                }
            }

            var productId = {$product_id|intval};
            var selectElement = document.getElementById('mtborica_recurring_plan_select_' + productId);
            var validateUrl = '{$validate_url|escape:'javascript':'UTF-8'}';
            var savePlanUrl = '{$save_plan_url|escape:'javascript':'UTF-8'}';
            var hasRecurringPlans = {if isset($has_recurring_plans) && $has_recurring_plans}true{else}false{/if};

            // Update hidden field when plan selection changes (only if selector exists)
            if (selectElement) {
                selectElement.addEventListener('change', function() {
                    var selectedPlanId = parseInt(this.value) || 0;
                    var hiddenField = document.getElementById('mtborica_recurring_plan_id_' + productId);
                    if (hiddenField) {
                        hiddenField.value = selectedPlanId;
                    }
                });
            }

            // Store button click handler for later removal
            var buttonClickHandler = null;
            var addToCartButton = null;
            var addToCartForm = null;

            // Intercept add to cart button click
            function interceptAddToCart() {
                // Find add to cart button - PrestaShop 1.7 uses data-button-action="add-to-cart"
                addToCartButton = document.querySelector(
                    'button[data-button-action="add-to-cart"], ' +
                    'button.add-to-cart, ' +
                    'button#add-to-cart-button, ' +
                    'input[type="submit"][name*="add"], ' +
                    'button[type="submit"][name*="add"], ' +
                    'button.btn-primary[type="submit"]'
                );

                // If button not found, try to find form and then button inside
                if (!addToCartButton) {
                    // Try to find form with id containing "add-to-cart" or "add_to_cart"
                    var forms = document.querySelectorAll('form');
                    for (var i = 0; i < forms.length; i++) {
                        var formId = forms[i].id || '';
                        var formClass = forms[i].className || '';
                        if (formId.indexOf('add-to-cart') !== -1 ||
                            formId.indexOf('add_to_cart') !== -1 ||
                            formClass.indexOf('add-to-cart') !== -1 ||
                            formClass.indexOf('add_to_cart') !== -1) {
                            addToCartForm = forms[i];
                            addToCartButton = addToCartForm.querySelector(
                                'button[type="submit"], input[type="submit"], button[data-button-action="add-to-cart"]'
                            );
                            if (addToCartButton) {
                                break;
                            }
                        }
                    }
                } else {
                    // If button found, get its form
                    addToCartForm = addToCartButton.closest('form');
                }

                // If still no button, try to find by action attribute
                if (!addToCartButton) {
                    var forms = document.querySelectorAll('form[action*="cart"]');
                    if (forms.length > 0) {
                        addToCartForm = forms[0];
                        addToCartButton = addToCartForm.querySelector(
                            'button[type="submit"], input[type="submit"]'
                        );
                    }
                }

                if (!addToCartButton) {
                    return;
                }

                // Create button click handler
                buttonClickHandler = function(e) {
                    // If button is marked as validated, allow the click to proceed normally
                    var targetButton = e.target.closest('button') || addToCartButton;
                    if (targetButton && targetButton.getAttribute('data-mtborica-validated') === 'true') {
                        return; // Let the event proceed normally
                    }

                    e.preventDefault();
                    e.stopPropagation();
                    e.stopImmediatePropagation();

                    // Get selected plan ID - use selector if available, otherwise 0
                    var selectedPlanId = 0;
                    if (selectElement) {
                        selectedPlanId = parseInt(selectElement.value) || 0;
                    } else {
                        // For products without recurring plans, check hidden field
                        var hiddenField = document.getElementById('mtborica_recurring_plan_id_' + productId);
                        if (hiddenField) {
                            selectedPlanId = parseInt(hiddenField.value) || 0;
                        }
                    }
                    var productAttributeId = 0;

                    // Try to get product attribute ID from form
                    if (addToCartForm) {
                        var attributeInput = addToCartForm.querySelector(
                            'input[name="id_product_attribute"], input[name="idProductAttribute"]');
                        if (attributeInput) {
                            productAttributeId = parseInt(attributeInput.value) || 0;
                        }
                    }

                    // Validate before adding to cart
                    validateAndAddToCart(productId, selectedPlanId, productAttributeId, addToCartForm,
                        addToCartButton);
                };

                // Intercept button click - use capture phase to intercept early
                addToCartButton.addEventListener('click', buttonClickHandler, true);
            }

            // Validate and add to cart
            function validateAndAddToCart(productId, planId, productAttributeId, form, button) {
                // Show loading state
                var originalButtonText = button ? button.innerHTML : '';
                var originalButtonDisabled = button ? button.disabled : false;
                if (button) {
                    button.disabled = true;
                    button.innerHTML = '{l s="Validating..." mod="mtborica" js=1}';
                }

                // Prepare validation request
                var formData = new FormData();
                formData.append('product_id', productId);
                formData.append('recurring_plan_id', planId);
                formData.append('id_product_attribute', productAttributeId);

                // Make AJAX validation request
                fetch(validateUrl, {ldelim}
                method: 'POST',
                    body: formData,
                    credentials: 'same-origin'
                    {rdelim})
                    .then(function(response) {
                        if (!response.ok) {
                            throw new Error('HTTP error! status: ' + response.status);
                        }
                        return response.json();
                    })
                    .then(function(data) {
                        // Restore button state
                        if (button) {
                            button.disabled = originalButtonDisabled;
                            button.innerHTML = originalButtonText;
                        }

                        if (data.success && data.allowed) {
                            // Validation passed - proceed with normal add to cart
                            // Save plan ID to database after successful validation
                            var planIdToSave = planId;
                            var productIdToSave = productId;
                            var productAttributeIdToSave = productAttributeId;

                            // Set flag to allow the click to proceed normally
                            if (button) {
                                button.setAttribute('data-mtborica-validated', 'true');
                            }

                            // Trigger the original add to cart behavior
                            // Use setTimeout to ensure the flag is set before triggering
                            setTimeout(function() {
                                if (button) {
                                    // Create a new click event that will trigger the original behavior
                                    var syntheticEvent = new MouseEvent('click', {ldelim}
                                    bubbles: true,
                                    cancelable: true,
                                    view: window,
                                    detail: 1
                                    {rdelim});

                                    // Trigger the click - our handler will see the flag and allow it
                                    button.dispatchEvent(syntheticEvent);

                                    // Save plan ID to database after a delay (to allow cart to update)
                                    setTimeout(function() {
                                        if (planIdToSave > 0) {
                                            savePlanToDatabase(planIdToSave, productIdToSave,
                                                productAttributeIdToSave);
                                        }
                                    }, 500);

                                    // Remove the flag after a short delay
                                    setTimeout(function() {
                                        if (button) {
                                            button.removeAttribute('data-mtborica-validated');
                                        }
                                    }, 200);
                                }
                                else if (form) {
                                    // Fallback: submit form directly
                                    form.submit();

                                    // Save plan ID after form submission
                                    setTimeout(function() {
                                        if (planIdToSave > 0) {
                                            savePlanToDatabase(planIdToSave, productIdToSave,
                                                productAttributeIdToSave);
                                        }
                                    }, 500);
                                }
                            }, 10);
                        } else {
                            // Validation failed - show error message
                            var errorMessage = data.message || '{l s="Cannot add product to cart." mod="mtborica" js=1}';
                            showErrorMessage(errorMessage);
                        }
                    })
                    .catch(function(error) {
                        // Restore button state
                        if (button) {
                            button.disabled = originalButtonDisabled;
                            button.innerHTML = originalButtonText;
                        }

                        // On error, allow normal submission (fail open)
                        if (buttonClickHandler) {
                            button.removeEventListener('click', buttonClickHandler, true);
                        }

                        // Trigger the original add to cart behavior
                        // Use a small timeout to ensure our handler is fully removed
                        setTimeout(function() {
                            if (form) {
                                form.submit();
                            } else if (button) {
                                var clickEvent = new MouseEvent('click', {ldelim}
                                bubbles: true,
                                cancelable: true,
                                view: window
                                {rdelim});
                                button.dispatchEvent(clickEvent);
                            }
                        }, 10);
                    });
            }

            // Show error message to user
            function showErrorMessage(message) {
                // Remove any existing notification first
                var existingNotification = document.querySelector('.mtborica-error-notification');
                if (existingNotification) {
                    existingNotification.remove();
                }

                var customNotification = document.createElement('div');
                customNotification.className = 'mtborica-error-notification alert alert-danger';
                customNotification.style.cssText =
                    'position: fixed; top: 20px; left: 50%; transform: translateX(-50%); z-index: 10000; ' +
                    'max-width: 600px; min-width: 300px; padding: 15px 40px 15px 15px; margin: 0; ' +
                    'box-shadow: 0 4px 15px rgba(0,0,0,0.3); border-radius: 4px; ' +
                    'background-color: #f8d7da; border: 1px solid #f5c6cb; color: #721c24; ' +
                    'font-size: 14px; line-height: 1.5;';

                var closeButton = document.createElement('button');
                closeButton.type = 'button';
                closeButton.className = 'close';
                closeButton.innerHTML = '&times;';
                closeButton.style.cssText =
                    'position: absolute; right: 10px; top: 10px; background: none; border: none; ' +
                    'font-size: 24px; cursor: pointer; color: #721c24; line-height: 1; padding: 0; ' +
                    'width: 24px; height: 24px; display: flex; align-items: center; justify-content: center;';
                closeButton.onclick = function() {
                    customNotification.style.opacity = '0';
                    customNotification.style.transition = 'opacity 0.3s';
                    setTimeout(function() {
                        if (customNotification.parentNode) {
                            customNotification.remove();
                        }
                    }, 300);
                };

                var messageText = document.createElement('strong');
                messageText.textContent = message;
                messageText.style.cssText = 'display: block;';

                customNotification.appendChild(messageText);
                customNotification.appendChild(closeButton);
                document.body.appendChild(customNotification);

                // Auto-remove after 8 seconds
                setTimeout(function() {
                    if (customNotification.parentNode) {
                        customNotification.style.opacity = '0';
                        customNotification.style.transition = 'opacity 0.3s';
                        setTimeout(function() {
                            if (customNotification.parentNode) {
                                customNotification.remove();
                            }
                        }, 300);
                    }
                }, 8000);
            }

            // Save plan ID to database
            function savePlanToDatabase(planId, productId, productAttributeId) {
                if (!savePlanUrl) {
                    return;
                }

                // Get cart ID from PrestaShop context or cookie
                var cartId = 0;
                if (typeof prestashop !== 'undefined' && prestashop.cart && prestashop.cart.id) {
                    cartId = prestashop.cart.id;
                }

                var formData = new FormData();
                formData.append('cart_id', cartId);
                formData.append('product_id', productId);
                formData.append('id_product_attribute', productAttributeId);
                formData.append('recurring_plan_id', planId);

                fetch(savePlanUrl, {ldelim}
                method: 'POST',
                    body: formData,
                    credentials: 'same-origin'
                {rdelim}).then(function(response) {
                return response.json();
            }).then(function(data) {
            if (data.success) {
                // Plan saved successfully - no need to reload or call anything
                // The cart page will load the plan info automatically when it loads
            }
        }).catch(function(error) {
            // Silently fail
        });
    }

    // Initialize when DOM is ready
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', interceptAddToCart);
    } else {
        interceptAddToCart();
    }
    })();
</script>