{* Bank payment form template *}
<div class="mtborica-payment-form">
    <div class="payment-info">
        <h3>{l s='Redirecting to payment gateway...' mod='mtborica'}</h3>
        <p>{l s='Please wait while we redirect you to the secure payment page.' mod='mtborica'}</p>
    </div>

    <div class="loading-spinner">
        <div class="spinner"></div>
    </div>

    <form
        id="bank-payment-form"
        method="POST"
        action="{$borica_url}"
    >
        {foreach from=$borica_payment_data key=field_name item=field_value}
            <input
                type="hidden"
                name="{$field_name}"
                value="{$field_value|escape:'htmlall':'UTF-8'}"
            >
        {/foreach}
    </form>
</div>

{* Fullscreen overlay covering whole page *}
<div
    id="mtborica-fullscreen-overlay"
    aria-hidden="true"
>
    <div class="mtborica-overlay-backdrop"></div>
    <div
        class="mtborica-overlay-content"
        role="status"
        aria-live="polite"
    >
        <div class="spinner"></div>
        <div class="mtborica-overlay-text">{l s='Redirecting to the bank, please wait…' mod='mtborica'}</div>
    </div>
    <style>
        #mtborica-fullscreen-overlay {
            position: fixed;
            inset: 0;
            z-index: 99999;
            pointer-events: none;
        }

        #mtborica-fullscreen-overlay .mtborica-overlay-backdrop {
            position: absolute;
            inset: 0;
            background: rgba(0, 0, 0, 0.55);
        }

        #mtborica-fullscreen-overlay .mtborica-overlay-content {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 14px;
            color: #fff;
            text-align: center;
        }

        /* Reuse spinner style */
        #mtborica-fullscreen-overlay .spinner {
            width: 48px;
            height: 48px;
            border: 5px solid rgba(255, 255, 255, 0.35);
            border-top-color: #fff;
            border-radius: 50%;
            animation: mtb-spin 1s linear infinite;
        }

        #mtborica-fullscreen-overlay .mtborica-overlay-text {
            font-size: 16px;
        }

        @keyframes mtb-spin {
            0% {
                transform: rotate(0deg);
            }

            100% {
                transform: rotate(360deg);
            }
        }

        /* Lock page scroll while overlay visible */
        body.mtb-page-locked {
            overflow: hidden !important;
        }
    </style>
</div>

<style>
    .mtborica-payment-form {
        text-align: center;
        padding: 40px 20px;
        max-width: 600px;
        margin: 0 auto;
    }

    .payment-info {
        background: #f8f9fa;
        border: 1px solid #dee2e6;
        border-radius: 8px;
        padding: 30px;
        margin-bottom: 30px;
    }

    .payment-info h3 {
        color: #495057;
        margin-bottom: 15px;
    }

    .payment-info p {
        margin: 10px 0;
        color: #6c757d;
    }

    .loading-spinner {
        margin: 30px 0;
    }

    .spinner {
        width: 40px;
        height: 40px;
        border: 4px solid #f3f3f3;
        border-top: 4px solid #007bff;
        border-radius: 50%;
        animation: spin 1s linear infinite;
        margin: 0 auto;
    }

    @keyframes spin {
        0% {
            transform: rotate(0deg);
        }

        100% {
            transform: rotate(360deg);
        }
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        try {
            // Scroll to top and lock interactions visually with the fullscreen overlay
            window.scrollTo({ top: 0, left: 0, behavior: 'auto' });
            document.body.classList.add('mtb-page-locked');
            var overlay = document.getElementById('mtborica-fullscreen-overlay');
            if (overlay) { overlay.style.pointerEvents = 'auto'; }
        } catch (e) {}

        // Ensure inputs exist and then auto-submit shortly after
        setTimeout(function() {
            var form = document.getElementById('bank-payment-form');
            if (form) { form.submit(); }
        }, 700);
    });
</script>
