{extends file='page.tpl'}

{* Error display block *}
{if isset($mtborica_back_error) && $mtborica_back_error}
    {block name='page_content_container'}
        <section class="card">
            <div class="card-block">
                <div
                    class="alert alert-danger"
                    role="alert"
                >
                    <h4 class="alert-heading">{l s='Payment Error' mod='mtborica'}</h4>
                    {if isset($mtborica_back_errors) && !empty($mtborica_back_errors)}
                        <ul>
                            {foreach from=$mtborica_back_errors item=error}
                                <li>{$error|escape:'html':'UTF-8'}</li>
                            {/foreach}
                        </ul>
                    {else}
                        <p>{l s='Invalid payment parameters received.' mod='mtborica'}</p>
                    {/if}
                </div>
            </div>
        </section>
    {/block}
{else}
    {* Full order confirmation page *}
    {if isset($order) && $order}
        {block name='page_content_container' prepend}
            <section
                id="content-hook_order_confirmation"
                class="card"
            >
                <div class="card-block">
                    <div class="row">
                        <div class="col-md-12">
                            <h3 class="h1 card-title">
                                <i class="material-icons rtl-no-flip done">&#xE876;</i>
                                {l s='Your order is confirmed' d='Shop.Theme.Checkout'}
                            </h3>
                            {if isset($order.details.reference)}
                                <p>
                                    {l s='An email has been sent to your mail address %email%.' d='Shop.Theme.Checkout' sprintf=['%email%' => $customer.email]}
                                    {if isset($order.details.invoice_url) && $order.details.invoice_url}
                                        {l s='You can also [1]download your invoice[/1]' d='Shop.Theme.Checkout' sprintf=['[1]' => "<a href='{$order.details.invoice_url}'>",
                                        '[/1]' => "</a>"]}
                                    {/if}
                                </p>
                            {/if}
                        </div>
                    </div>
                </div>
            </section>
        {/block}

        {block name='page_content_container'}
            <section
                id="content"
                class="page-content page-order-confirmation card"
            >
                <div class="card-block">
                    <div class="row">
                        {if isset($order.products)}
                            {block name='order_confirmation_table'}
                                {include file='checkout/_partials/order-confirmation-table.tpl' products=$order.products subtotals=$order.subtotals totals=$order.totals labels=$order.labels add_product_link=false}
                            {/block}
                        {/if}

                        {block name='order_details'}
                            <div
                                id="order-details"
                                class="col-md-12"
                            >
                                <h3 class="h3 card-title">{l s='Order details' d='Shop.Theme.Checkout'}:</h3>
                                <ul>
                                    {if isset($order.details.reference)}
                                        <li id="order-reference-value">
                                            {l s='Order reference: %reference%' d='Shop.Theme.Checkout' sprintf=['%reference%' => $order.details.reference]}
                                        </li>
                                    {/if}
                                    <li>
                                        {if isset($payment_method_name) && $payment_method_name}
                                            {l s='Payment method: %method%' d='Shop.Theme.Checkout' sprintf=['%method%' => $payment_method_name]}
                                            {if $boricaTestMode == 1}(<span style="color:red;">TEST MODE</span>){/if}
                                        {elseif isset($order.details.payment) && $order.details.payment}
                                            {l s='Payment method: %method%' d='Shop.Theme.Checkout' sprintf=['%method%' => $order.details.payment]}
                                            {if $boricaTestMode == 1}(<span style="color:red;">TEST MODE</span>){/if}
                                        {else}
                                            {l s='Payment method: %method%' d='Shop.Theme.Checkout' sprintf=['%method%' => 'N/A']}
                                        {/if}
                                    </li>
                                    {if isset($order.details.is_virtual) && !$order.details.is_virtual && isset($order.carrier)}
                                        <li>
                                            {l s='Shipping method: %method%' d='Shop.Theme.Checkout' sprintf=['%method%' => $order.carrier.name]}<br>
                                            <em>{$order.carrier.delay}</em>
                                        </li>
                                    {/if}
                                </ul>
                            </div>
                        {/block}
                    </div>
                </div>
            </section>

            {* Payment information block *}
            {block name='hook_payment_return'}
                <section
                    id="content-hook_payment_return"
                    class="card definition-list"
                >
                    <div class="card-block">
                        <div class="row">
                            <div class="col-md-12">
                                <h3 class="h3 card-title">{l s='Payment Information:' mod='mtborica'}</h3>
                                <dl class="row">
                                    {if $paymentSuccess}
                                        {if $checkAuthorization}
                                            <div
                                                id="payment-information"
                                                class="col-md-12"
                                            >
                                                <ul>
                                                    <li class="h4">
                                                        <i class="material-icons rtl-no-flip done">&#xE876;</i>
                                                        {$boricaSuccessMessage|escape:'html':'UTF-8'}
                                                    </li>
                                                    <li>
                                                        {l s='Cardholder Information:' mod='mtborica'}&nbsp;
                                                        <strong>
                                                            {$boricaCardholderinfo|escape:'html':'UTF-8'}
                                                        </strong>
                                                    </li>
                                                    <li>
                                                        {l s='Your order number is:' mod='mtborica'}&nbsp;
                                                        <strong>
                                                            {$boricaOrder|escape:'html':'UTF-8'}
                                                        </strong>
                                                    </li>
                                                    {if !$isRecurringDrop}
                                                        <li>
                                                            <strong>{l s='We will send you an order confirmation email with details and tracking information.' mod='mtborica'}</strong>
                                                        </li>
                                                    {/if}
                                                </ul>
                                            </div>
                                        {else}
                                            <div
                                                id="payment-information-unsuccess"
                                                class="col-md-12"
                                            >
                                                <ul>
                                                    <li class="h4">
                                                        <span style="color:red;">{$boricaUnsuccessMessage|escape:'html':'UTF-8'}</span>
                                                    </li>
                                                    <li>
                                                        {l s='Your order number is:' mod='mtborica'}&nbsp;
                                                        <strong>
                                                            {$boricaOrder|escape:'html':'UTF-8'}
                                                        </strong>
                                                    </li>
                                                </ul>
                                            </div>
                                        {/if}
                                    {else}
                                        <div
                                            id="payment-information-unsuccess"
                                            class="col-md-12"
                                        >
                                            <ul>
                                                <li class="h4">
                                                    <span style="color:red;">{$boricaUnsuccessMessage|escape:'html':'UTF-8'}</span>
                                                </li>
                                                <li>
                                                    {l s='Cardholder Information:' mod='mtborica'}&nbsp;
                                                    <strong>
                                                        {$boricaCardholderinfo|escape:'html':'UTF-8'}
                                                    </strong>
                                                </li>
                                                <li>
                                                    {l s='Your order number is:' mod='mtborica'}&nbsp;
                                                    <strong>
                                                        {$boricaOrder|escape:'html':'UTF-8'}
                                                    </strong>
                                                </li>
                                            </ul>
                                        </div>
                                    {/if}
                                    <hr />
                                    <div class="buttons">
                                        <div class="pull-right">
                                            <a
                                                href="{$baseUrl|escape:'html':'UTF-8'}"
                                                class="btn btn-primary"
                                            >{l s='Continue shopping' mod='mtborica'}</a>
                                        </div>
                                    </div>
                                </dl>
                            </div>
                        </div>
                    </div>
                </section>
            {/block}

            {block name='customer_registration_form'}
                {if isset($customer.is_guest) && $customer.is_guest && isset($register_form)}
                    <div
                        id="registration-form"
                        class="card"
                    >
                        <div class="card-block">
                            <h4 class="h4">{l s='Save time on your next order, sign up now' d='Shop.Theme.Checkout'}</h4>
                            {render file='customer/_partials/customer-form.tpl' ui=$register_form}
                        </div>
                    </div>
                {/if}
            {/block}
        {/block}
    {else}
        {* Short payment information only *}
        {block name='page_content_container'}
            <section class="card">
                <div class="card-block">
                    <h3 class="h3 card-title">{l s='Payment Return' mod='mtborica'}</h3>
                    <div class="row">
                        <div class="col-md-12">
                            <dl class="row">
                            </dl>
                        </div>
                    </div>
                </div>
            </section>
        {/block}
    {/if}
{/if}