{*
* Template for the configuration of the mtborica module
* File: views/templates/admin/configure.tpl
*}

<div class="panel">
    <div class="panel-heading">
        <i class="icon-cogs"></i> {l s='BORICA - Payment by Credit/Debit Card' mod='mtborica'}
    </div>

    <form
        method="post"
        action="{$smarty.server.REQUEST_URI|escape:'htmlall':'UTF-8'}"
        enctype="multipart/form-data"
    >
        <input
            type="hidden"
            name="submitmtborica"
            value="1"
        />
        <!-- BORICA settings -->
        <div class="panel">
            <div class="panel-heading">
                <i class="icon-toggle-on"></i> {l s='BORICA - Payment by Credit/Debit Card' mod='mtborica'}
            </div>
            <div class="panel-body">
                <div class="form-group">
                    <label class="control-label col-lg-4">{l s='Enable' mod='mtborica'}</label>
                    <div class="col-lg-8">
                        <span class="switch prestashop-switch fixed-width-lg">
                            <input
                                type="radio"
                                name="mtborica_status"
                                id="mtborica_status_on"
                                value="1"
                                {if $mtborica_status == 1}checked="checked"
                                {/if}
                            >
                            <label for="mtborica_status_on">{l s='Yes' mod='mtborica'}</label>
                            <input
                                type="radio"
                                name="mtborica_status"
                                id="mtborica_status_off"
                                value="0"
                                {if $mtborica_status == 0}checked="checked"
                                {/if}
                            >
                            <label for="mtborica_status_off">{l s='No' mod='mtborica'}</label>
                            <a class="slide-button btn"></a>
                        </span>
                        <p class="help-block">{l s='Enable/Disable BORICA - Credit/Debit Card Payment' mod='mtborica'}
                        </p>
                    </div>
                </div>

                <div class="form-group">
                    <label class="control-label col-lg-4">{l s='Mode of operation' mod='mtborica'}</label>
                    <div class="col-lg-8">
                        <select
                            name="mtborica_testmode"
                            class="form-control"
                        >
                            <option
                                value="1"
                                {if $mtborica_testmode == 1}selected{/if}
                            >
                                {l s='Test' mod='mtborica'}</option>
                            <option
                                value="0"
                                {if $mtborica_testmode == 0}selected{/if}
                            >
                                {l s='Production' mod='mtborica'}</option>
                        </select>
                        <p class="help-block">
                            {l s='Changes Test/Production Mode to BORICA - Payment by Credit/Debit Card' mod='mtborica'}
                        </p>
                    </div>
                </div>

                <div class="form-group">
                    <label class="control-label col-lg-4">{l s='Debug mode' mod='mtborica'}</label>
                    <div class="col-lg-8">
                        <span class="switch prestashop-switch fixed-width-lg">
                            <input
                                type="radio"
                                name="mtborica_debug"
                                id="mtborica_debug_on"
                                value="1"
                                {if $mtborica_debug == 1}checked="checked"
                                {/if}
                            >
                            <label for="mtborica_debug_on">{l s='Yes' mod='mtborica'}</label>
                            <input
                                type="radio"
                                name="mtborica_debug"
                                id="mtborica_debug_off"
                                value="0"
                                {if $mtborica_debug == 0}checked="checked"
                                {/if}
                            >
                            <label for="mtborica_debug_off">{l s='No' mod='mtborica'}</label>
                            <a class="slide-button btn"></a>
                        </span>
                        <p class="help-block">
                            {l s='Enable/Disable debug mode in BORICA - Payment by Credit/Debit Card' mod='mtborica'}
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Basic settings -->
        <div class="panel">
            <div class="panel-heading">
                <i class="icon-toggle-on"></i> {l s='Basic Settings' mod='mtborica'}
            </div>
            <div class="panel-body">
                <div class="form-group">
                    <label class="control-label col-lg-4">{l s='Return URL (BackRef)' mod='mtborica'}</label>
                    <div class="col-lg-8">
                        <span class="form-control-static">
                            {$mtborica_back_url|escape:'html':'UTF-8'}
                        </span>
                        <p class="help-block">
                            {l s='Send this URL to your bank/BORICA' mod='mtborica'}
                        </p>
                    </div>
                </div>

                <div class="form-group">
                    <label class="control-label col-lg-4">{l s='Merchant Name' mod='mtborica'}</label>
                    <div class="col-lg-8">
                        <input
                            type="text"
                            name="mtborica_mname"
                            value="{$mtborica_mname|escape:'htmlall':'UTF-8'}"
                            class="form-control"
                        >
                        <p class="help-block">
                            {l s='Merchant Name. Your customers will see this on their statement to identify the payment' mod='mtborica'}
                        </p>
                    </div>
                </div>

                <div class="form-group">
                    <label class="control-label col-lg-4">{l s='Payment failed' mod='mtborica'}</label>
                    <div class="col-lg-8">
                        <input
                            type="text"
                            name="mtborica_unsuccess_message"
                            value="{$mtborica_unsuccess_message|escape:'htmlall':'UTF-8'}"
                            class="form-control"
                        >
                        <p class="help-block">
                            {l s='You can change this message to what you want your customers to see when a payment fails.' mod='mtborica'}
                        </p>
                    </div>
                </div>

                <div class="form-group">
                    <label class="control-label col-lg-4">{l s='Payment is successful' mod='mtborica'}</label>
                    <div class="col-lg-8">
                        <input
                            type="text"
                            name="mtborica_success_message"
                            value="{$mtborica_success_message|escape:'htmlall':'UTF-8'}"
                            class="form-control"
                        >
                        <p class="help-block">
                            {l s='You can change this message with what you want your customers to see upon successful payment.' mod='mtborica'}
                        </p>
                    </div>
                </div>

                <div class="form-group">
                    <label class="control-label col-lg-4">{l s='Merchant email' mod='mtborica'}</label>
                    <div class="col-lg-8">
                        <input
                            type="email"
                            name="mtborica_email"
                            value="{$mtborica_email|escape:'htmlall':'UTF-8'}"
                            class="form-control"
                        >
                        <p class="help-block">
                            {l s='Merchant email. E-mail address for notifications' mod='mtborica'}
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Terminals Settings -->
        <div class="row">
            <div class="col-lg-6">
                <div class="panel">
                    <div class="panel-heading">
                        <i class="icon-money"></i> {l s='Terminal BGN' mod='mtborica'}
                    </div>
                    <div class="panel-body">
                        <div class="panel-body">
                            <div class="form-group">
                                <label
                                    class="control-label col-lg-4">{l s='Merchant Identifier (MID)' mod='mtborica'}</label>
                                <div class="col-lg-8">
                                    <input
                                        type="text"
                                        name="mtborica_mid_bgn"
                                        value="{$mtborica_mid_bgn|escape:'htmlall':'UTF-8'}"
                                        class="form-control"
                                    >
                                    <p class="help-block">
                                        {l s='Merchant ID provided by your bank/BORICA' mod='mtborica'}
                                    </p>
                                </div>
                            </div>

                            <div class="form-group">
                                <label
                                    class="control-label col-lg-4">{l s='Terminal Identifier (TID)' mod='mtborica'}</label>
                                <div class="col-lg-8">
                                    <input
                                        type="text"
                                        name="mtborica_tid_bgn"
                                        value="{$mtborica_tid_bgn|escape:'htmlall':'UTF-8'}"
                                        class="form-control"
                                    >
                                    <p class="help-block">
                                        {l s='Terminal ID provided by your bank/BORICA' mod='mtborica'}
                                    </p>
                                </div>
                            </div>
                        </div>

                        <!-- Test Environment Settings -->
                        <div class="panel">
                            <div class="panel-heading">
                                <i class="icon-flask"></i> {l s='Test Environment Settings' mod='mtborica'}
                            </div>
                            <div class="panel-body">
                                <div class="form-group">
                                    <label class="control-label col-lg-4">{l s='Private key' mod='mtborica'}</label>
                                    <div class="col-lg-8">
                                        <textarea
                                            name="mtborica_test_key_bgn"
                                            rows="5"
                                            class="form-control"
                                        >{$mtborica_test_key_bgn|escape:'htmlall':'UTF-8'}</textarea>
                                        <p class="help-block">
                                            {l s='Enter your private key in this field. You can use the tool provided by BORICA to generate a private key. You can access the tool from the link provided just below in help section (Generate Private Key and CSR)' mod='mtborica'}
                                        </p>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label
                                        class="control-label col-lg-4">{l s='Private key password' mod='mtborica'}</label>
                                    <div class="col-lg-8">
                                        <input
                                            type="password"
                                            name="mtborica_test_password_bgn"
                                            value="{$mtborica_test_password_bgn|escape:'htmlall':'UTF-8'}"
                                            class="form-control"
                                        >
                                        <p class="help-block">
                                            {l s='The password for your private key. You can leave it blank if there is none.' mod='mtborica'}
                                        </p>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label
                                        class="control-label col-lg-4">{l s='Compliance check' mod='mtborica'}</label>
                                    <div class="col-lg-8">
                                        <button
                                            type="button"
                                            id="borica_button_bgn_test"
                                            class="btn btn-primary"
                                        >
                                            <i class="icon-check"></i> {l s='Check' mod='mtborica'}
                                        </button>
                                        <p class="help-block">
                                            {l s='Check for correspondence between private key and issued certificate' mod='mtborica'}
                                        </p>
                                    </div>
                                </div>

                            </div>
                        </div>

                        <!-- Production Environment -->
                        <div class="panel">
                            <div class="panel-heading">
                                <i class="icon-rocket"></i> {l s='Production Environment Settings' mod='mtborica'}
                            </div>
                            <div class="panel-body">
                                <div class="form-group">
                                    <label class="control-label col-lg-4">{l s='Private key' mod='mtborica'}</label>
                                    <div class="col-lg-8">
                                        <textarea
                                            name="mtborica_production_key_bgn"
                                            rows="5"
                                            class="form-control"
                                        >{$mtborica_production_key_bgn|escape:'htmlall':'UTF-8'}</textarea>
                                        <p class="help-block">
                                            {l s='Enter your private key in this field. You can use the tool provided by BORICA to generate a private key. You can access the tool from the link provided just below in help section (Generate Private Key and CSR)' mod='mtborica'}
                                        </p>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label
                                        class="control-label col-lg-4">{l s='Private key password' mod='mtborica'}</label>
                                    <div class="col-lg-8">
                                        <input
                                            type="password"
                                            name="mtborica_production_password_bgn"
                                            value="{$mtborica_production_password_bgn|escape:'htmlall':'UTF-8'}"
                                            class="form-control"
                                        >
                                        <p class="help-block">
                                            {l s='The password for your private key.' mod='mtborica'}
                                        </p>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label
                                        class="control-label col-lg-4">{l s='Compliance check' mod='mtborica'}</label>
                                    <div class="col-lg-8">
                                        <button
                                            type="button"
                                            id="borica_button_bgn_production"
                                            class="btn btn-primary"
                                        >
                                            <i class="icon-check"></i> {l s='Check' mod='mtborica'}
                                        </button>
                                        <p class="help-block">
                                            {l s='Check for correspondence between private key and issued certificate' mod='mtborica'}
                                        </p>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <!-- Terminal EUR Settings -->
                <div class="panel">
                    <div class="panel-heading">
                        <i class="icon-euro"></i> {l s='Terminal EUR' mod='mtborica'}
                    </div>
                    <div class="panel-body">
                        <div class="panel-body">
                            <div class="form-group">
                                <label
                                    class="control-label col-lg-4">{l s='Merchant Identifier (MID)' mod='mtborica'}</label>
                                <div class="col-lg-8">
                                    <input
                                        type="text"
                                        name="mtborica_mid_eur"
                                        value="{$mtborica_mid_eur|escape:'htmlall':'UTF-8'}"
                                        class="form-control"
                                    >
                                    <p class="help-block">
                                        {l s='Merchant ID provided by your bank/BORICA' mod='mtborica'}
                                    </p>
                                </div>
                            </div>

                            <div class="form-group">
                                <label
                                    class="control-label col-lg-4">{l s='Terminal Identifier (TID)' mod='mtborica'}</label>
                                <div class="col-lg-8">
                                    <input
                                        type="text"
                                        name="mtborica_tid_eur"
                                        value="{$mtborica_tid_eur|escape:'htmlall':'UTF-8'}"
                                        class="form-control"
                                    >
                                    <p class="help-block">
                                        {l s='Terminal ID provided by your bank/BORICA' mod='mtborica'}
                                    </p>
                                </div>
                            </div>
                        </div>

                        <!-- Test Environment Settings -->
                        <div class="panel">
                            <div class="panel-heading">
                                <i class="icon-flask"></i> {l s='Test Environment Settings' mod='mtborica'}
                            </div>
                            <div class="panel-body">
                                <div class="form-group">
                                    <label class="control-label col-lg-4">{l s='Private key' mod='mtborica'}</label>
                                    <div class="col-lg-8">
                                        <textarea
                                            name="mtborica_test_key_eur"
                                            rows="5"
                                            class="form-control"
                                        >{$mtborica_test_key_eur|escape:'htmlall':'UTF-8'}</textarea>
                                        <p class="help-block">
                                            {l s='Enter your private key in this field. You can use the tool provided by BORICA to generate a private key. You can access the tool from the link provided just below in help section (Generate Private Key and CSR)' mod='mtborica'}
                                        </p>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label
                                        class="control-label col-lg-4">{l s='Private key password' mod='mtborica'}</label>
                                    <div class="col-lg-8">
                                        <input
                                            type="password"
                                            name="mtborica_test_password_eur"
                                            value="{$mtborica_test_password_eur|escape:'htmlall':'UTF-8'}"
                                            class="form-control"
                                        >
                                        <p class="help-block">
                                            {l s='The password for your private key. You can leave it blank if there is none.' mod='mtborica'}
                                        </p>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label
                                        class="control-label col-lg-4">{l s='Compliance check' mod='mtborica'}</label>
                                    <div class="col-lg-8">
                                        <button
                                            type="button"
                                            id="borica_button_eur_test"
                                            class="btn btn-primary"
                                        >
                                            <i class="icon-check"></i> {l s='Check' mod='mtborica'}
                                        </button>
                                        <p class="help-block">
                                            {l s='Check for correspondence between private key and issued certificate' mod='mtborica'}
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Production Environment -->
                        <div class="panel">
                            <div class="panel-heading">
                                <i class="icon-rocket"></i> {l s='Production Environment Settings' mod='mtborica'}
                            </div>
                            <div class="panel-body">
                                <div class="form-group">
                                    <label class="control-label col-lg-4">{l s='Private key' mod='mtborica'}</label>
                                    <div class="col-lg-8">
                                        <textarea
                                            name="mtborica_production_key_eur"
                                            rows="5"
                                            class="form-control"
                                        >{$mtborica_production_key_eur|escape:'htmlall':'UTF-8'}</textarea>
                                        <p class="help-block">
                                            {l s='Enter your private key in this field. You can use the tool provided by BORICA to generate a private key. You can access the tool from the link provided just below in help section (Generate Private Key and CSR)' mod='mtborica'}
                                        </p>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label
                                        class="control-label col-lg-4">{l s='Private key password' mod='mtborica'}</label>
                                    <div class="col-lg-8">
                                        <input
                                            type="password"
                                            name="mtborica_production_password_eur"
                                            value="{$mtborica_production_password_eur|escape:'htmlall':'UTF-8'}"
                                            class="form-control"
                                        >
                                        <p class="help-block">
                                            {l s='The password for your private key.' mod='mtborica'}
                                        </p>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label
                                        class="control-label col-lg-4">{l s='Compliance check' mod='mtborica'}</label>
                                    <div class="col-lg-8">
                                        <button
                                            type="button"
                                            id="borica_button_eur_production"
                                            class="btn btn-primary"
                                        >
                                            <i class="icon-check"></i> {l s='Check' mod='mtborica'}
                                        </button>
                                        <p class="help-block">
                                            {l s='Check for correspondence between private key and issued certificate' mod='mtborica'}
                                        </p>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Additional Settings -->
        <div class="panel">
            <div class="panel-heading">
                <i class="icon-cogs"></i> {l s='Additional Settings' mod='mtborica'}
            </div>
            <div class="panel-body">

                <div class="form-group">
                    <label
                        class="control-label col-lg-4">{l s='Order status after successful payment' mod='mtborica'}</label>
                    <div class="col-lg-8">
                        <select
                            name="mtborica_order_status_id"
                            class="form-control"
                        >
                            {foreach from=$order_states item=order_state}
                                <option
                                    value="{$order_state.id_order_state|escape:'htmlall':'UTF-8'}"
                                    {if $mtborica_order_status_id == $order_state.id_order_state}selected{/if}
                                >
                                    {$order_state.name|escape:'htmlall':'UTF-8'}
                                </option>
                            {/foreach}
                        </select>
                        <p class="help-block">
                            {l s='Order status after successful payment' mod='mtborica'}
                        </p>
                    </div>
                </div>

                <div class="form-group">
                    <label
                        class="control-label col-lg-4">{l s='Order status after unsuccessful payment' mod='mtborica'}</label>
                    <div class="col-lg-8">
                        <select
                            name="mtborica_order_status_not_id"
                            class="form-control"
                        >
                            {foreach from=$order_states item=order_state}
                                <option
                                    value="{$order_state.id_order_state|escape:'htmlall':'UTF-8'}"
                                    {if $mtborica_order_status_not_id == $order_state.id_order_state}selected{/if}
                                >
                                    {$order_state.name|escape:'htmlall':'UTF-8'}
                                </option>
                            {/foreach}
                        </select>
                        <p class="help-block">
                            {l s='Order status after unsuccessful payment' mod='mtborica'}
                        </p>
                    </div>
                </div>

                <div class="form-group">
                    <label class="control-label col-lg-4">{l s='Default payment page language' mod='mtborica'}</label>
                    <div class="col-lg-8">
                        <select
                            name="mtborica_payment_lang"
                            class="form-control"
                        >
                            <option
                                value="BG"
                                {if $mtborica_payment_lang == 'BG'}selected{/if}
                            >
                                BG – Български/Bulgarian
                            </option>
                            <option
                                value="EN"
                                {if $mtborica_payment_lang == 'EN'}selected{/if}
                            >
                                EN – Английски/English
                            </option>
                            <option
                                value="DE"
                                {if $mtborica_payment_lang == 'DE'}selected{/if}
                            >
                                DE - Немски/German
                            </option>
                            <option
                                value="PL"
                                {if $mtborica_payment_lang == 'PL'}selected{/if}
                            >
                                PL – Полски/Polish
                            </option>
                            <option
                                value="CZ"
                                {if $mtborica_payment_lang == 'CZ'}selected{/if}
                            >
                                CZ – Чешки/Czech
                            </option>
                            <option
                                value="ES"
                                {if $mtborica_payment_lang == 'ES'}selected{/if}
                            >
                                ES – Испански/Spanish
                            </option>
                            <option
                                value="RU"
                                {if $mtborica_payment_lang == 'RU'}selected{/if}
                            >
                                RU - Руски/Russian
                            </option>
                            <option
                                value="UA"
                                {if $mtborica_payment_lang == 'UA'}selected{/if}
                            >
                                UA - Украински/Ukrainian
                            </option>
                            <option
                                value="FR"
                                {if $mtborica_payment_lang == 'FR'}selected{/if}
                            >
                                FR – Френски/French
                            </option>
                            <option
                                value="RO"
                                {if $mtborica_payment_lang == 'RO'}selected{/if}
                            >
                                RO – Румънски/Romanian
                            </option>
                            <option
                                value="GR"
                                {if $mtborica_payment_lang == 'GR'}selected{/if}
                            >
                                GR – Гръцки/Greek
                            </option>
                            <option
                                value="TR"
                                {if $mtborica_payment_lang == 'TR'}selected{/if}
                            >
                                TR - Турски/Turkish
                            </option>
                            <option
                                value="MK"
                                {if $mtborica_payment_lang == 'MK'}selected{/if}
                            >
                                MK - Македонски/Macedonian
                            </option>
                            <option
                                value="RS"
                                {if $mtborica_payment_lang == 'RS'}selected{/if}
                            >
                                RS - Сръбски/Serbian
                            </option>
                        </select>
                        <p class="help-block">
                            {l s='Use this option to specify the default language of the BORICA payment page.' mod='mtborica'}
                        </p>
                    </div>
                </div>

            </div>
        </div>

        <!-- Recurring Payments -->
        <div class="panel">
            <div class="panel-heading">
                <i class="icon-repeat"></i> {l s='Recurring Payments' mod='mtborica'}
            </div>
            <div class="panel-body">
                <div class="form-group">
                    <label class="control-label col-lg-4">{l s='Enable recurring payments' mod='mtborica'}</label>
                    <div class="col-lg-8">
                        <span class="switch prestashop-switch fixed-width-lg">
                            <input
                                type="radio"
                                name="mtborica_recurring"
                                id="mtborica_recurring_on"
                                value="1"
                                {if $mtborica_recurring == 1}checked="checked"
                                {/if}
                            >
                            <label for="mtborica_recurring_on">{l s='Yes' mod='mtborica'}</label>
                            <input
                                type="radio"
                                name="mtborica_recurring"
                                id="mtborica_recurring_off"
                                value="0"
                                {if $mtborica_recurring == 0}checked="checked"
                                {/if}
                            >
                            <label for="mtborica_recurring_off">{l s='No' mod='mtborica'}</label>
                            <a class="slide-button btn"></a>
                        </span>
                        <p class="help-block">
                            {l s='Enable/Disable recurring payments mode in BORICA - Payment by Credit/Debit Card' mod='mtborica'}
                        </p>
                    </div>
                </div>

                <div class="form-group">
                    <label
                        class="control-label col-lg-4">{l s='Show button to close a recurring plan' mod='mtborica'}</label>
                    <div class="col-lg-8">
                        <span class="switch prestashop-switch fixed-width-lg">
                            <input
                                type="radio"
                                name="mtborica_recurring_cancel_button"
                                id="mtborica_recurring_cancel_button_on"
                                value="1"
                                {if $mtborica_recurring_cancel_button == 1}checked="checked"
                                {/if}
                            >
                            <label for="mtborica_recurring_cancel_button_on">{l s='Yes' mod='mtborica'}</label>
                            <input
                                type="radio"
                                name="mtborica_recurring_cancel_button"
                                id="mtborica_recurring_cancel_button_off"
                                value="0"
                                {if $mtborica_recurring_cancel_button == 0}checked="checked"
                                {/if}
                            >
                            <label for="mtborica_recurring_cancel_button_off">{l s='No' mod='mtborica'}</label>
                            <a class="slide-button btn"></a>
                        </span>
                        <p class="help-block">
                            {l s='Enable/Disable display a button to stop recurring payment on the order review page' mod='mtborica'}
                        </p>
                    </div>
                </div>

                <!-- Table for recurring payments -->
                <div id="recurring-plans"></div>
                <div
                    id="mtborica_recurring_table"
                    style="display: none;"
                >
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>{l s='ID' mod='mtborica'}</th>
                                    <th>{l s='Name' mod='mtborica'}</th>
                                    <th>{l s='Status' mod='mtborica'}</th>
                                    <th>{l s='Actions' mod='mtborica'}</th>
                                </tr>
                            </thead>
                            <tbody>
                                {foreach from=$mtborica_recurrings item=recurring}
                                    <tr data-id="{$recurring.id}">
                                        <td>{$recurring.id}</td>
                                        <td>{$recurring.name}</td>
                                        <td>
                                            <span
                                                class="label {if $recurring.status == 1}label-success{else}label-default{/if}"
                                            >
                                                {if $recurring.status == 1}{l s='Active' mod='mtborica'}{else}{l s='Inactive' mod='mtborica'}{/if}
                                            </span>
                                        </td>
                                        <td>
                                            <button
                                                type="button"
                                                class="btn {if $recurring.status == 1}btn-success{else}btn-secondary{/if} btn-sm borica_toggle_status"
                                                data-id="{$recurring.id}"
                                            >
                                                {if $recurring.status == 1}{l s='Deactivate' mod='mtborica'}{else}{l s='Activate' mod='mtborica'}{/if}
                                            </button>
                                            <button
                                                type="button"
                                                class="btn btn-default btn-sm borica_edit_recurring"
                                                data-id="{$recurring.id}"
                                            >
                                                <i class="icon-edit"></i> {l s='Edit' mod='mtborica'}
                                            </button>
                                            <button
                                                type="button"
                                                class="btn btn-danger btn-sm borica_delete_recurring"
                                                data-id="{$recurring.id}"
                                            >
                                                <i class="icon-trash"></i> {l s='Delete' mod='mtborica'}
                                            </button>
                                        </td>
                                    </tr>
                                {/foreach}
                            </tbody>
                        </table>
                    </div>

                    <button
                        type="button"
                        id="borica_button_recurring_create"
                        class="btn btn-success"
                    >
                        <i class="icon-plus"></i> {l s='Add Recurring Payment' mod='mtborica'}
                    </button>
                </div>
            </div>
        </div>

        <!-- Modal window for recurring payment -->
        <div
            id="mtborica_recurring_modal"
            class="modal fade"
            tabindex="-1"
            role="dialog"
        >
            <div
                class="modal-dialog"
                role="document"
            >
                <div class="modal-content">
                    <div class="modal-header">
                        <button
                            type="button"
                            class="close"
                            data-dismiss="modal"
                        >&times;</button>
                        <h4 class="modal-title">{l s='Add/Edit Recurring Payment' mod='mtborica'}</h4>
                    </div>
                    <div class="modal-body">
                        <input
                            type="hidden"
                            id="mtborica_recurring_id"
                            value="0"
                        >

                        <div class="form-group">
                            <input
                                type="text"
                                id="mtborica_recurring_name"
                                class="form-control"
                                placeholder="{l s='Enter name' mod='mtborica'}"
                            >
                        </div>

                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label>
                                        {l s='Duration' mod='mtborica'}
                                        <i
                                            class="icon-question-circle"
                                            data-toggle="tooltip"
                                            title="{l s='Duration of the plan' mod='mtborica'}"
                                            style="margin-left:6px; cursor:help;"
                                        ></i>
                                    </label>
                                    <input
                                        type="text"
                                        id="mtborica_recurring_duration"
                                        class="form-control"
                                        maxlength="4"
                                    >
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label>
                                        {l s='Duration Unit' mod='mtborica'}
                                        <i
                                            class="icon-question-circle"
                                            data-toggle="tooltip"
                                            title="{l s='Unit for the duration of the plan\'s action.:"D" – day (default if undefined), "M" - month, "Q" - quarter, "H" - 6 months, "Y" - year' mod='mtborica'}"
                                            style="margin-left:6px; cursor:help;"
                                        ></i>
                                    </label>
                                    <select
                                        id="mtborica_recurring_duration_unit"
                                        class="form-control"
                                    >
                                        <option value="D">{l s='day' mod='mtborica'}</option>
                                        <option value="M">{l s='month' mod='mtborica'}</option>
                                        <option value="Q">{l s='quarter' mod='mtborica'}</option>
                                        <option value="H">{l s='6 Months' mod='mtborica'}</option>
                                        <option value="Y">{l s='year' mod='mtborica'}</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>
                                        {l s='Frequency' mod='mtborica'}
                                        <i
                                            class="icon-question-circle"
                                            data-toggle="tooltip"
                                            title="{l s='Frequency of execution of subsequent payments: number of periods between authorizations (e.g. with a value of "10" and frequency unit is day, payments are made once every 10 days' mod='mtborica'}"
                                            style="margin-left:6px; cursor:help;"
                                        ></i>
                                    </label>
                                    <input
                                        type="text"
                                        id="mtborica_recurring_frequency"
                                        class="form-control"
                                        maxlength="4"
                                    >
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>
                                        {l s='Frequency unit' mod='mtborica'}
                                        <i
                                            class="icon-question-circle"
                                            data-toggle="tooltip"
                                            title="{l s='Subsequent payment execution period:"D" – day (default if undefined), "M" - month, "Q" - quarter, "H" - 6 months, "Y" - year' mod='mtborica'}"
                                            style="margin-left:6px; cursor:help;"
                                        ></i>
                                    </label>
                                    <select
                                        id="mtborica_recurring_frequency_unit"
                                        class="form-control"
                                    >
                                        <option value="D">{l s='day' mod='mtborica'}</option>
                                        <option value="M">{l s='month' mod='mtborica'}</option>
                                        <option value="Q">{l s='quarter' mod='mtborica'}</option>
                                        <option value="H">{l s='6 Months' mod='mtborica'}</option>
                                        <option value="Y">{l s='year' mod='mtborica'}</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>
                                        {l s='Mday payment' mod='mtborica'}
                                        <i
                                            class="icon-question-circle"
                                            data-toggle="tooltip"
                                            title="{l s='Day of the month for executing the subsequent payment for a given monthly period in the Frequency unit field [1..31]. With a value of "31", payments are scheduled on the last calendar day of the month.' mod='mtborica'}"
                                            style="margin-left:6px; cursor:help;"
                                        ></i>
                                    </label>
                                    <input
                                        type="text"
                                        id="mtborica_recurring_mday_payment"
                                        class="form-control"
                                        maxlength="2"
                                    >
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button
                            type="button"
                            class="btn btn-default"
                            data-dismiss="modal"
                        >{l s='Cancel' mod='mtborica'}</button>
                        <button
                            type="button"
                            id="borica_modal_save"
                            class="btn btn-primary"
                        >{l s='Save' mod='mtborica'}</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Help Section -->
        <div class="panel">
            <div class="panel-heading">
                <i class="icon-question-circle"></i> {l s='Help' mod='mtborica'}
            </div>
            <div class="panel-body">
                <p><strong>{l s='Help' mod='mtborica'}:</strong>
                    <a
                        href="https://3dsgate-dev.borica.bg/generateCSR"
                        target="_blank"
                        rel="noopener"
                    >
                        {l s='Generate private key and CSR' mod='mtborica'}
                    </a>
                </p>
                <p><strong>{l s='Help' mod='mtborica'}:</strong>
                    <a
                        href="https://3dsgate-dev.borica.bg/prestashopplugin"
                        target="_blank"
                        rel="noopener"
                    >
                        {l s='More information about the plugin' mod='mtborica'}
                    </a>
                </p>
            </div>
        </div>

        <div class="panel-footer">
            <button
                type="submit"
                class="btn btn-default pull-right"
            >
                <i class="process-icon-save"></i> {l s='Save' mod='mtborica'}
            </button>
        </div>
    </form>
</div>

<!-- CSS for the static form control -->
<style>
    .form-control-static {
        font-size: 18px;
        font-weight: bold;
        color: #3170ac;
    }
</style>

<!-- SweetAlert2 CSS -->
<link
    rel="stylesheet"
    href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css"
>

<!-- Additional SweetAlert2 styles to override admin styles -->
<style>
    .swal2-popup {
        font-family: inherit !important;
    }

    .swal2-title {
        font-size: 1.5rem !important;
        font-weight: 600 !important;
        color: #333 !important;
    }

    .swal2-content {
        font-size: 1rem !important;
        color: #666 !important;
    }

    .swal2-confirm {
        background-color: #1E91CF !important;
        border: none !important;
        border-radius: 4px !important;
        padding: 10px 20px !important;
        font-size: 14px !important;
        font-weight: 500 !important;
    }

    .swal2-confirm:hover {
        background-color: #1a7bb8 !important;
    }

    .swal2-icon {
        width: 64px !important;
        height: 64px !important;
        margin: 20px auto 30px !important;
    }

    .swal2-icon.swal2-success {
        border-color: #28a745 !important;
        color: #28a745 !important;
    }

    .swal2-icon.swal2-error {
        border-color: #dc3545 !important;
        color: #dc3545 !important;
    }

    /* Custom classes for SweetAlert2 */
    .swal2-popup-custom {
        font-family: inherit !important;
        border-radius: 8px !important;
        padding: 20px !important;
    }

    .swal2-title-custom {
        font-size: 1.2rem !important;
        font-weight: 600 !important;
        color: #333 !important;
        margin-bottom: 12px !important;
    }

    .swal2-title-custom.error-title {
        color: #dc3545 !important;
    }

    .swal2-content-custom {
        font-size: 0.9rem !important;
        color: #666 !important;
        line-height: 1.4 !important;
    }

    .swal2-confirm-custom {
        background-color: #1E91CF !important;
        border: none !important;
        border-radius: 4px !important;
        padding: 10px 20px !important;
        font-size: 14px !important;
        font-weight: 500 !important;
        color: white !important;
    }

    .swal2-confirm-custom:hover {
        background-color: #1a7bb8 !important;
    }
</style>

<!-- JavaScript for the functionality -->
<script type="text/javascript">
    $(document).ready(function() {
        // Scroll to anchor if hash is present in URL (preserve scroll position after reload)
        if (window.location.hash) {
            var hash = window.location.hash.substring(1);
            if (hash === 'recurring-plans') {
                // Show recurring table if it's hidden
                $('#mtborica_recurring_table').show();
                $('#mtborica_recurring_on').prop('checked', true);
            }
            var targetElement = $('#' + hash);
            if (targetElement.length) {
                setTimeout(function() {
                    $('html, body').animate({
                        scrollTop: targetElement.offset().top - 100
                    }, 500);
                }, 100);
            }
        }
        // Lightweight client-side sanitizers (defense-in-depth; server still validates)
        const sanitizeText = function(value, maxLen) {
            var v = (value == null ? '' : String(value));
            v = v.replace(/[\u0000-\u001F\u007F]/g, ''); // strip control chars
            v = $.trim(v).replace(/\s+/g, ' ');
            if (maxLen && maxLen > 0) {
                v = v.slice(0, maxLen);
            }
            return v;
        };
        const sanitizeIntStr = function(value, maxLen) {
            var v = (value == null ? '' : String(value));
            v = v.replace(/[^0-9]/g, '');
            if (maxLen && maxLen > 0) {
                v = v.slice(0, maxLen);
            }
            return v;
        };
        const sanitizeUnit = function(value) {
            var allowed = ['D', 'M', 'Q', 'H', 'Y'];
            var v = (value == null ? '' : String(value).toUpperCase());
            return allowed.indexOf(v) !== -1 ? v : 'D';
        };
        // Show/hide the reccuring table on start
        if ($('#mtborica_recurring_on').is(':checked')) {
            $('#mtborica_recurring_table').show();
        } else {
            $('#mtborica_recurring_table').hide();
        }

        // Show/hide the recurring table
        $('#mtborica_recurring_on').change(function() {
            if ($(this).is(':checked')) {
                $('#mtborica_recurring_table').show();
            }
        });

        $('#mtborica_recurring_off').change(function() {
            if ($(this).is(':checked')) {
                $('#mtborica_recurring_table').hide();
            }
        });

        // Modal window for recurring payment
        $('#borica_button_recurring_create').click(function() {
            $('#mtborica_recurring_modal').modal({
                backdrop: 'static',
                keyboard: false
            });
        });

        // AJAX operations for recurring payments
        $('.borica_toggle_status').click(function() {
            var id = $(this).data('id');
            var button = $(this);

            $.ajax({
                url: '{$mtborica_toggle_status_url|escape:'htmlall':'UTF-8'}',
                type: 'post',
                dataType: 'json',
                data: {
                    id: id
                },
                success: (json) => {
                    if (json.success) {
                        // Get the table row
                        var row = button.closest('tr');
                        var statusCell = row.find('td:nth-child(3)');
                        var statusLabel = statusCell.find('span');

                        // Toggle button text and class
                        if (button.hasClass('btn-success')) {
                            button.removeClass('btn-success').addClass('btn-secondary');
                            button.text('{l s='Activate' mod='mtborica'}');

                            // Update status label
                            statusLabel.removeClass('label-success').addClass(
                                'label-default');
                            statusLabel.text('{l s='Inactive' mod='mtborica'}');
                        } else {
                            button.removeClass('btn-secondary').addClass('btn-success');
                            button.text('{l s='Deactivate' mod='mtborica'}');

                            // Update status label
                            statusLabel.removeClass('label-default').addClass(
                                'label-success');
                            statusLabel.text('{l s='Active' mod='mtborica'}');
                        }

                        Swal.fire({
                            title: 'Success',
                            text: json.message || 'Status updated successfully!',
                            confirmButtonColor: '#1E91CF',
                            confirmButtonText: 'OK',
                            allowOutsideClick: false,
                            customClass: {
                                popup: 'swal2-popup-custom',
                                title: 'swal2-title-custom',
                                content: 'swal2-content-custom',
                                confirmButton: 'swal2-confirm-custom'
                            }
                        });
                    } else {
                        Swal.fire({
                            title: 'Error',
                            text: json.message || 'Failed to update status.',
                            confirmButtonColor: '#1E91CF',
                            confirmButtonText: 'OK',
                            allowOutsideClick: false,
                            customClass: {
                                popup: 'swal2-popup-custom',
                                title: 'swal2-title-custom error-title',
                                content: 'swal2-content-custom',
                                confirmButton: 'swal2-confirm-custom'
                            }
                        });
                    }
                },
                error: (xhr, status, error) => {
                    Swal.fire({
                        title: 'Error',
                        text: xhr.responseJSON && xhr.responseJSON.message ? xhr
                            .responseJSON.message : 'Error updating status.',
                        confirmButtonColor: '#1E91CF',
                        confirmButtonText: 'OK',
                        allowOutsideClick: false,
                        customClass: {
                            popup: 'swal2-popup-custom',
                            title: 'swal2-title-custom error-title',
                            content: 'swal2-content-custom',
                            confirmButton: 'swal2-confirm-custom'
                        }
                    });
                }
            });
        });

        $('.borica_edit_recurring').click(function() {
            var id = $(this).data('id');
            var row = $(this).closest('tr');

            // Load data via AJAX
            $.ajax({
                url: '{$mtborica_get_recurring_url|escape:'htmlall':'UTF-8'}',
                type: 'get',
                dataType: 'json',
                data: { id: id },
                success: (json) => {
                    if (json && json.success && json.data) {
                        // Fill modal fields
                        $('#mtborica_recurring_id').val(json.data.id);
                        $('#mtborica_recurring_name').val(json.data.name);
                        $('#mtborica_recurring_duration').val(json.data.recur_duration);
                        $('#mtborica_recurring_duration_unit').val(json.data
                            .recur_duration_unit);
                        $('#mtborica_recurring_frequency').val(json.data.recur_freq);
                        $('#mtborica_recurring_frequency_unit').val(json.data
                            .recur_freq_unit);
                        $('#mtborica_recurring_mday_payment').val(json.data
                            .recur_mday_payment);

                        // Open modal
                        $('#mtborica_recurring_modal').modal({
                            backdrop: 'static',
                            keyboard: false
                        });
                    } else {
                        Swal.fire({
                            title: 'Error',
                            text: (json && json.message) ? json.message : '{l s='Failed to load recurring plan.' mod='mtborica'}',
                            confirmButtonColor: '#1E91CF',
                            confirmButtonText: 'OK',
                            allowOutsideClick: false,
                            customClass: {
                                popup: 'swal2-popup-custom',
                                title: 'swal2-title-custom error-title',
                                content: 'swal2-content-custom',
                                confirmButton: 'swal2-confirm-custom'
                            }
                        });
                    }
                },
                error: () => {
                    Swal.fire({
                        title: 'Error',
                        text: '{l s='Error loading recurring plan.' mod='mtborica'}',
                        confirmButtonColor: '#1E91CF',
                        confirmButtonText: 'OK',
                        allowOutsideClick: false,
                        customClass: {
                            popup: 'swal2-popup-custom',
                            title: 'swal2-title-custom error-title',
                            content: 'swal2-content-custom',
                            confirmButton: 'swal2-confirm-custom'
                        }
                    });
                }
            });
        });

        $('.borica_delete_recurring').click(function() {
            var id = $(this).data('id');
            var button = $(this);

            Swal.fire({
                title: '{l s='Delete Recurring Payment' mod='mtborica'}',
                text: '{l s='Are you sure you want to delete this recurring payment?' mod='mtborica'}',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: '{l s='Yes, delete it!' mod='mtborica'}',
                cancelButtonText: '{l s='Cancel' mod='mtborica'}',
                customClass: {
                    popup: 'swal2-popup-custom',
                    title: 'swal2-title-custom',
                    content: 'swal2-content-custom',
                    confirmButton: 'swal2-confirm-custom',
                    cancelButton: 'swal2-confirm-custom'
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: '{$mtborica_delete_recurring_url|escape:'htmlall':'UTF-8'}',
                        type: 'post',
                        dataType: 'json',
                        data: {
                            id: id
                        },
                        success: (json) => {
                            if (json.success) {
                                // Remove the table row
                                button.closest('tr').fadeOut(300, function() {
                                    $(this).remove();
                                });

                                Swal.fire({
                                    title: 'Success',
                                    text: json.message ||
                                        'Recurring payment deleted successfully!',
                                    confirmButtonColor: '#1E91CF',
                                    confirmButtonText: 'OK',
                                    allowOutsideClick: false,
                                    customClass: {
                                        popup: 'swal2-popup-custom',
                                        title: 'swal2-title-custom',
                                        content: 'swal2-content-custom',
                                        confirmButton: 'swal2-confirm-custom'
                                    }
                                });
                            } else {
                                Swal.fire({
                                    title: 'Error',
                                    text: json.message ||
                                        'Failed to delete recurring payment.',
                                    confirmButtonColor: '#1E91CF',
                                    confirmButtonText: 'OK',
                                    allowOutsideClick: false,
                                    customClass: {
                                        popup: 'swal2-popup-custom',
                                        title: 'swal2-title-custom error-title',
                                        content: 'swal2-content-custom',
                                        confirmButton: 'swal2-confirm-custom'
                                    }
                                });
                            }
                        },
                        error: (xhr, status, error) => {
                            Swal.fire({
                                title: 'Error',
                                text: xhr.responseJSON && xhr.responseJSON
                                    .message ? xhr.responseJSON.message :
                                    'Error deleting recurring payment.',
                                confirmButtonColor: '#1E91CF',
                                confirmButtonText: 'OK',
                                allowOutsideClick: false,
                                customClass: {
                                    popup: 'swal2-popup-custom',
                                    title: 'swal2-title-custom error-title',
                                    content: 'swal2-content-custom',
                                    confirmButton: 'swal2-confirm-custom'
                                }
                            });
                        }
                    });
                }
            });
        });

        $('#borica_modal_save').click(function(e) {
            e.preventDefault();
            var id = parseInt($('#mtborica_recurring_id').val(), 10) || 0;
            var isEdit = id > 0;
            var url = isEdit ? '{$mtborica_update_recurring_url|escape:'htmlall':'UTF-8'}' : '{$mtborica_modal_save_url|escape:'htmlall':'UTF-8'}';

            var nameVal = sanitizeText($('#mtborica_recurring_name').val(), 128);
            var durationVal = sanitizeIntStr($('#mtborica_recurring_duration').val(), 4);
            var durationUnitVal = sanitizeUnit($('#mtborica_recurring_duration_unit').val());
            var frequencyVal = sanitizeIntStr($('#mtborica_recurring_frequency').val(), 4);
            var frequencyUnitVal = sanitizeUnit($('#mtborica_recurring_frequency_unit').val());
            var mdayPaymentVal = sanitizeIntStr($('#mtborica_recurring_mday_payment').val(), 2);

            var payload = {
                name: nameVal,
                duration: durationVal,
                duration_unit: durationUnitVal,
                frequency: frequencyVal,
                frequency_unit: frequencyUnitVal,
                mday_payment: mdayPaymentVal
            };
            if (isEdit) {
                payload.id = id;
            }

            $.ajax({
                url: url,
                type: 'post',
                dataType: 'json',
                data: payload,
                success: (json) => {
                    if (json && json.success) {
                        Swal.fire({
                            title: '{l s='Success' mod='mtborica'}',
                            text: json.message || (isEdit ? '{$mtborica_translations.recurring_plan_updated_success|escape:'javascript':'UTF-8'}' : '{$mtborica_translations.recurring_plan_saved_success|escape:'javascript':'UTF-8'}'),
                            confirmButtonColor: '#1E91CF',
                            confirmButtonText: 'OK',
                            allowOutsideClick: false,
                            customClass: {
                                popup: 'swal2-popup-custom',
                                title: 'swal2-title-custom',
                                content: 'swal2-content-custom',
                                confirmButton: 'swal2-confirm-custom'
                            }
                        }).then(() => {
                            // Close modal after success
                            $('#mtborica_recurring_modal').modal('hide');
                            // Reset fields
                            $('#mtborica_recurring_modal').find('input, select')
                                .val('');
                            if (isEdit) {
                                // Update row values dynamically (text-only, safe)
                                var row = $('tr[data-id="' + id + '"]');
                                row.find('td:nth-child(2)').text(nameVal);
                            } else {
                                // Reload page to show new entry, preserving scroll position
                                window.location.hash = 'recurring-plans';
                                location.reload();
                            }
                        });
                    } else {
                        const errorText = (json && json.errors) ?
                            Object.values(json.errors).join('\n')
                        : (json && json.message) || '{$mtborica_translations.recurring_plan_save_failed|escape:'javascript':'UTF-8'}';
                        Swal.fire({
                            title: 'Error',
                            text: errorText,
                            confirmButtonColor: '#1E91CF',
                            confirmButtonText: 'OK',
                            allowOutsideClick: false,
                            customClass: {
                                popup: 'swal2-popup-custom',
                                title: 'swal2-title-custom error-title',
                                content: 'swal2-content-custom',
                                confirmButton: 'swal2-confirm-custom'
                            }
                        });
                    }
                },
                error: (xhr, status, error) => {
                    const resp = xhr && xhr.responseJSON ? xhr.responseJSON : null;
                    const errorText = resp && resp.message ?
                        resp.message :
                        (resp && resp.errors ? Object.values(resp.errors).join('\n') : (
                            error ||
                            'Unexpected error'));
                    Swal.fire({
                        title: 'Error',
                        text: errorText,
                        confirmButtonColor: '#1E91CF',
                        confirmButtonText: 'OK',
                        allowOutsideClick: false,
                        customClass: {
                            popup: 'swal2-popup-custom',
                            title: 'swal2-title-custom error-title',
                            content: 'swal2-content-custom',
                            confirmButton: 'swal2-confirm-custom'
                        }
                    });
                }
            });
        });

        // Compliance check buttons
        $('#borica_button_bgn_test').click(function(e) {
            e.preventDefault();
            const fileDialogTestBgn = $(
                '<input id="test_keys_file_bgn" type="file" accept="application/pkix-cert">');
            fileDialogTestBgn.click();
            fileDialogTestBgn.on('change', onFileSelectedTestBgn);
            return false;
        });

        const onFileSelectedTestBgn = (e) => {
            const reader = new FileReader();
            reader.addEventListener('load', (event) => {
                const content_key = event.target.result;
                $.ajax({
                    url: '{$mtborica_test_keys_bgn_url|escape:'htmlall':'UTF-8'}',
                    type: 'post',
                    dataType: 'json',
                    data: {
                        PUBLIC_CERTIFICATE: content_key
                    },
                    success: (json) => {
                        const isError = json.checkCertTitle === 'Error';
                        Swal.fire({
                            title: json.checkCertTitle,
                            text: json.checkCertText,
                            confirmButtonColor: '#1E91CF',
                            confirmButtonText: json.confirmButtonText || 'OK',
                            allowOutsideClick: false,
                            customClass: {
                                popup: 'swal2-popup-custom',
                                title: isError ?
                                    'swal2-title-custom error-title' :
                                    'swal2-title-custom',
                                content: 'swal2-content-custom',
                                confirmButton: 'swal2-confirm-custom'
                            }
                        });
                    },
                    error: (xhr, status, error) => {
                        Swal.fire({
                            title: 'Error',
                            text: xhr.responseJSON.checkCertText ||
                                'Error checking certificate',
                            confirmButtonColor: '#1E91CF',
                            confirmButtonText: 'OK',
                            allowOutsideClick: false,
                            customClass: {
                                popup: 'swal2-popup-custom',
                                title: 'swal2-title-custom error-title',
                                content: 'swal2-content-custom',
                                confirmButton: 'swal2-confirm-custom'
                            }
                        });
                    }
                });
            });
            if (e.target.files.length > 0) {
                reader.readAsDataURL(e.target.files[0]);
            }
        };

        // Production compliance check button
        $('#borica_button_bgn_production').click(function(e) {
            e.preventDefault();
            const fileDialogProductionBgn = $(
                '<input id="production_keys_file_bgn" type="file" accept="application/pkix-cert">');
            fileDialogProductionBgn.click();
            fileDialogProductionBgn.on('change', onFileSelectedProductionBgn);
            return false;
        });

        const onFileSelectedProductionBgn = (e) => {
            const reader = new FileReader();
            reader.addEventListener('load', (event) => {
                const content_key = event.target.result;
                $.ajax({
                    url: '{$mtborica_production_keys_bgn_url|escape:'htmlall':'UTF-8'}',
                    type: 'post',
                    dataType: 'json',
                    data: {
                        PUBLIC_CERTIFICATE: content_key
                    },
                    success: (json) => {
                        const isError = json.checkCertTitle === 'Error';
                        Swal.fire({
                            title: json.checkCertTitle,
                            text: json.checkCertText,
                            confirmButtonColor: '#1E91CF',
                            confirmButtonText: json.confirmButtonText || 'OK',
                            allowOutsideClick: false,
                            customClass: {
                                popup: 'swal2-popup-custom',
                                title: isError ?
                                    'swal2-title-custom error-title' :
                                    'swal2-title-custom',
                                content: 'swal2-content-custom',
                                confirmButton: 'swal2-confirm-custom'
                            }
                        });
                    },
                    error: (xhr, status, error) => {
                        Swal.fire({
                            title: 'Error',
                            text: xhr.responseJSON.checkCertText ||
                                'Error checking certificate',
                            confirmButtonColor: '#1E91CF',
                            confirmButtonText: 'OK',
                            allowOutsideClick: false,
                            customClass: {
                                popup: 'swal2-popup-custom',
                                title: 'swal2-title-custom error-title',
                                content: 'swal2-content-custom',
                                confirmButton: 'swal2-confirm-custom'
                            }
                        });
                    }
                });
            });
            if (e.target.files.length > 0) {
                reader.readAsDataURL(e.target.files[0]);
            }
        };

        // EUR Test compliance check button
        $('#borica_button_eur_test').click(function(e) {
            e.preventDefault();
            const fileDialogTestEur = $(
                '<input id="test_keys_file_eur" type="file" accept="application/pkix-cert">');
            fileDialogTestEur.click();
            fileDialogTestEur.on('change', onFileSelectedTestEur);
            return false;
        });

        const onFileSelectedTestEur = (e) => {
            const reader = new FileReader();
            reader.addEventListener('load', (event) => {
                const content_key = event.target.result;
                $.ajax({
                    url: '{$mtborica_test_keys_eur_url|escape:'htmlall':'UTF-8'}',
                    type: 'post',
                    dataType: 'json',
                    data: {
                        PUBLIC_CERTIFICATE: content_key
                    },
                    success: (json) => {
                        const isError = json.checkCertTitle === 'Error';
                        Swal.fire({
                            title: json.checkCertTitle,
                            text: json.checkCertText,
                            confirmButtonColor: '#1E91CF',
                            confirmButtonText: json.confirmButtonText || 'OK',
                            allowOutsideClick: false,
                            customClass: {
                                popup: 'swal2-popup-custom',
                                title: isError ?
                                    'swal2-title-custom error-title' :
                                    'swal2-title-custom',
                                content: 'swal2-content-custom',
                                confirmButton: 'swal2-confirm-custom'
                            }
                        });
                    },
                    error: (xhr, status, error) => {
                        Swal.fire({
                            title: 'Error',
                            text: xhr.responseJSON.checkCertText ||
                                'Error checking certificate',
                            confirmButtonColor: '#1E91CF',
                            confirmButtonText: 'OK',
                            allowOutsideClick: false,
                            customClass: {
                                popup: 'swal2-popup-custom',
                                title: 'swal2-title-custom error-title',
                                content: 'swal2-content-custom',
                                confirmButton: 'swal2-confirm-custom'
                            }
                        });
                    }
                });
            });
            if (e.target.files.length > 0) {
                reader.readAsDataURL(e.target.files[0]);
            }
        };

        // EUR Production compliance check button
        $('#borica_button_eur_production').click(function(e) {
            e.preventDefault();
            const fileDialogProductionEur = $(
                '<input id="production_keys_file_eur" type="file" accept="application/pkix-cert">');
            fileDialogProductionEur.click();
            fileDialogProductionEur.on('change', onFileSelectedProductionEur);
            return false;
        });

        const onFileSelectedProductionEur = (e) => {
            const reader = new FileReader();
            reader.addEventListener('load', (event) => {
                const content_key = event.target.result;
                $.ajax({
                    url: '{$mtborica_production_keys_eur_url|escape:'htmlall':'UTF-8'}',
                    type: 'post',
                    dataType: 'json',
                    data: {
                        PUBLIC_CERTIFICATE: content_key
                    },
                    success: (json) => {
                        const isError = json.checkCertTitle === 'Error';
                        Swal.fire({
                            title: json.checkCertTitle,
                            text: json.checkCertText,
                            confirmButtonColor: '#1E91CF',
                            confirmButtonText: json.confirmButtonText || 'OK',
                            allowOutsideClick: false,
                            customClass: {
                                popup: 'swal2-popup-custom',
                                title: isError ?
                                    'swal2-title-custom error-title' :
                                    'swal2-title-custom',
                                content: 'swal2-content-custom',
                                confirmButton: 'swal2-confirm-custom'
                            }
                        });
                    },
                    error: (xhr, status, error) => {
                        Swal.fire({
                            title: 'Error',
                            text: xhr.responseJSON.checkCertText ||
                                'Error checking certificate',
                            confirmButtonColor: '#1E91CF',
                            confirmButtonText: 'OK',
                            allowOutsideClick: false,
                            customClass: {
                                popup: 'swal2-popup-custom',
                                title: 'swal2-title-custom error-title',
                                content: 'swal2-content-custom',
                                confirmButton: 'swal2-confirm-custom'
                            }
                        });
                    }
                });
            });
            if (e.target.files.length > 0) {
                reader.readAsDataURL(e.target.files[0]);
            }
        };

    });
</script>

<!-- SweetAlert2 JavaScript -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>