/** mtborica checkout js */
// Enhance payment option title by coloring the last parenthetical suffix
(function () {
  function setPaymentTitleHighlightWithjQuery() {
    if (typeof $ === 'undefined') {
      return;
    }
    var warnedOnce = false;
    $('input[data-module-name="mtborica"]').each(function () {
      var $input = $(this);
      var id = $input.attr('id');
      if (!id) {
        return;
      }
      var $label = $('label[for="' + id + '"]');
      if (!$label.length) {
        return;
      }
      var $span = $label.find('span').first();
      var $target = $span.length ? $span : $label;
      if ($target.find('.mtborica-test-label').length) {
        return;
      }

      var text = $target.text();
      if (!text) {
        return;
      }
      var open = text.lastIndexOf('(');
      var close = text.lastIndexOf(')');
      if (open === -1 || close === -1 || close <= open) {
        if (!warnedOnce) {
          try {
            console.warn(
              'MTBORICA: Could not locate parenthetical test label in payment option title.'
            );
          } catch (e) {}
          warnedOnce = true;
        }
        return;
      }
      var before = text.substring(0, open);
      var middle = text.substring(open, close + 1);
      var after = text.substring(close + 1);
      var html =
        before +
        '<span class="mtborica-test-label">' +
        middle +
        '</span>' +
        after;
      $target.html(html);
    });
  }

  function setScreenFields() {
    try {
      var screenHeight = typeof screen !== 'undefined' ? screen.height : 0;
      var screenWidth = typeof screen !== 'undefined' ? screen.width : 0;
      // Update fields in additionalInformation (for display/debugging)
      var heightField = document.getElementById('mtborica_screen_height');
      var widthField = document.getElementById('mtborica_screen_width');
      if (heightField) {
        heightField.value = screenHeight;
      }
      if (widthField) {
        widthField.value = screenWidth;
      }
      // Also update fields in the payment form (these are the ones actually submitted)
      var formHeightField = document.querySelector(
        'form#payment-form input[name="browserScreenHeight"]'
      );
      var formWidthField = document.querySelector(
        'form#payment-form input[name="browserScreenWidth"]'
      );
      if (formHeightField) {
        formHeightField.value = screenHeight;
      }
      if (formWidthField) {
        formWidthField.value = screenWidth;
      }
    } catch (e) {
      try {
        console.warn('MTBORICA: Could not update screen data:', e);
      } catch (e2) {}
    }
  }

  function hideOtherPaymentMethods() {
    // Check if we have recurring payment (by checking for recurring plan ID in hidden input)
    var recurringPlanInput = document.querySelector(
      'input[name="mtborica_recurring_plan_id"]'
    );
    var isRecurringPayment =
      recurringPlanInput &&
      recurringPlanInput.value &&
      parseInt(recurringPlanInput.value) > 0;

    if (!isRecurringPayment) {
      // Not a recurring payment - show all payment methods
      var hiddenMethods = document.querySelectorAll(
        '.payment-option[data-mtborica-hidden]'
      );
      hiddenMethods.forEach(function (method) {
        method.style.display = '';
        method.removeAttribute('data-mtborica-hidden');
      });
      return;
    }

    // Recurring payment - hide all other payment methods except mtborica
    var allPaymentOptions = document.querySelectorAll('.payment-option');
    var mtboricaInput = document.querySelector(
      'input[data-module-name="mtborica"]'
    );
    var mtboricaOption = mtboricaInput
      ? mtboricaInput.closest('.payment-option')
      : null;

    allPaymentOptions.forEach(function (option) {
      if (option !== mtboricaOption) {
        // Hide other payment methods
        if (option.style.display !== 'none') {
          option.style.display = 'none';
          option.setAttribute('data-mtborica-hidden', 'true');
        }
      } else if (mtboricaOption) {
        // Ensure mtborica option is visible
        mtboricaOption.style.display = '';
        mtboricaOption.removeAttribute('data-mtborica-hidden');
      }
    });
  }

  function initObservers() {
    // jQuery-driven updates when payment option is selected or payment list changes
    if (typeof $ !== 'undefined') {
      $(function () {
        setPaymentTitleHighlightWithjQuery();
        setScreenFields();
        hideOtherPaymentMethods();
      });
      $(document).on(
        'change click',
        'input[data-module-name="mtborica"]',
        function () {
          setTimeout(function () {
            setScreenFields();
          }, 0);
        }
      );
      // Common events emitted on checkout updates in PS/themes
      $(document).on(
        'updatedPaymentMethods updatedCart updatedDeliveryForm',
        function () {
          setTimeout(function () {
            setPaymentTitleHighlightWithjQuery();
            setScreenFields();
            hideOtherPaymentMethods();
          }, 0);
        }
      );
      // Update screen fields right before form submission
      $(document).on('submit', 'form#payment-form', function (e) {
        setScreenFields();
      });
    }

    // Fallbacks for plain DOM
    document.addEventListener('DOMContentLoaded', function () {
      setPaymentTitleHighlightWithjQuery();
      setScreenFields();
      hideOtherPaymentMethods();
    });
    window.addEventListener('load', function () {
      setPaymentTitleHighlightWithjQuery();
      setScreenFields();
      hideOtherPaymentMethods();
    });

    // Update screen fields right before form submission (fallback without jQuery)
    document.addEventListener(
      'submit',
      function (e) {
        var form = e.target;
        if (form && form.id === 'payment-form') {
          setScreenFields();
        }
      },
      true
    );

    // MutationObserver to catch dynamic injection/re-render of payment block
    try {
      var observer = new MutationObserver(function () {
        setScreenFields();
        hideOtherPaymentMethods();
      });
      observer.observe(document.body, { childList: true, subtree: true });
    } catch (e) {
      /* no-op */
    }
  }

  initObservers();
})();
