<?php
/**
 * Class MtboricaTestKeysBgnModuleFrontController
 *
 * Validates correspondence between configured test private key/password
 * and a provided public certificate (base64 in data: URI) for BGN.
 * Responds with JSON for the admin UI.
 */
class MtboricaTestKeysBgnModuleFrontController extends ModuleFrontController
{

    public $result = null;

    /**
     * Handles the AJAX request for key/certificate validation.
     *
     * Input: POST `PUBLIC_CERTIFICATE` - data: URI base64 X.509 certificate
     * Output: JSON fields `checkCertTitle`, `checkCertText`, `confirmButtonText`
     *
     * @return void
     */
    public function initContent()
    {
        parent::initContent();
        $this->ajax = true;

        // Check if user is logged in admin - use cookie-based check
        $cookie = new Cookie('psAdmin');
        if (!$cookie->id_employee || !$cookie->isLoggedBack()) {
            die(json_encode(array(
                'error' => true,
                'checkCertTitle' => 'Error',
                'checkCertText' => 'You must be logged in as administrator'
            )));
        }

        $this->result = array(
            'checkCertTitle' => $this->l('Error'),
            'checkCertText' => $this->l('Test for correspondence between private key and public key failed.'),
            'confirmButtonText' => $this->l('Yes'),
        );

        if (isset($_SERVER['REQUEST_METHOD']) && 'POST' === $_SERVER['REQUEST_METHOD']) {

            if (!empty(Tools::getValue('PUBLIC_CERTIFICATE'))) {
                $certificate_data = (string) Tools::getValue('PUBLIC_CERTIFICATE');
                $prefix = 'data:application/x-x509-ca-cert;base64,';

                if (strpos($certificate_data, $prefix) === 0) {
                    $certificate_data = substr($certificate_data, strlen($prefix));
                    $public_certificate = base64_decode($certificate_data);

                    if (false === $public_certificate) {
                        $this->result['checkCertText'] = $this->l('Invalid base64 code.');
                    } else {
                        $borica_test_key_bgn = (string) Configuration::get('mtborica_test_key_bgn');
                        $borica_test_password_bgn = (string) Configuration::get('mtborica_test_password_bgn');
                        $pkeyid = openssl_get_privatekey($borica_test_key_bgn, $borica_test_password_bgn);
                        $check_cert = openssl_x509_check_private_key($public_certificate, $pkeyid);

                        $this->result = array(
                            'checkCertTitle' => $check_cert ?
                                $this->l('Message') :
                                $this->l('Error'),
                            'checkCertText' => $check_cert ?
                                $this->l('Successful match test between private key and public key.') :
                                $this->l('Test for correspondence between private key and public key failed.'),
                            'confirmButtonText' => $this->l('Yes'),
                        );
                    }
                } else {
                    $this->result['checkCertText'] = $this->l('A valid data: URI format is missing.');
                }
            } else {
                $this->result['checkCertText'] = $this->l('A valid data: URI format is missing.');
            }
        }
    }

    /**
     * Outputs the JSON response.
     *
     * @return void
     */
    public function displayAjax()
    {
        header('Content-Type: application/json');
        die(Tools::jsonEncode($this->result));
    }
}
