<?php
require_once _PS_MODULE_DIR_ . 'mtborica/mtborica.php';

/**
 * Class MtboricaGetCartPlanModuleFrontController
 *
 * AJAX controller for getting recurring plan name for a product in cart.
 * Used by JavaScript to display plan information in cart.
 */
class MtboricaGetCartPlanModuleFrontController extends ModuleFrontController
{
    /**
     * Aggregated JSON payload to be returned by displayAjax().
     *
     * @var array|null
     */
    public $result = null;

    /**
     * Initializes controller content for AJAX flow.
     *
     * @return void
     */
    public function initContent()
    {
        parent::initContent();
        $this->ajax = true;

        // Check if recurring feature is enabled
        if (!Mtborica::isRecurringEnabled()) {
            $this->result = [
                'success' => false,
                'plan_name' => '',
            ];
            return;
        }

        $this->result = [];

        // Get parameters
        $product_id = (int) Tools::getValue('product_id', 0);
        $product_attribute_id = (int) Tools::getValue('id_product_attribute', 0);

        if ($product_id <= 0) {
            $this->result = [
                'success' => false,
                'plan_name' => '',
            ];
            return;
        }

        // Get cart ID from context
        $cart_id = (int) ($this->context->cart->id ?? 0);
        if ($cart_id <= 0) {
            $this->result = [
                'success' => false,
                'plan_name' => '',
            ];
            return;
        }

        // Get plan ID from database
        $plan_id = Mtborica::getCartProductRecurringPlan($cart_id, $product_id, $product_attribute_id);

        if ($plan_id <= 0) {
            $this->result = [
                'success' => false,
                'plan_name' => '',
            ];
            return;
        }

        // Load plan information
        require_once _PS_MODULE_DIR_ . 'mtborica/classes/MtboricaRecurring.php';
        $plan = MtboricaRecurring::getById($plan_id);

        if (!$plan || !$plan->id) {
            $this->result = [
                'success' => false,
                'plan_name' => '',
            ];
            return;
        }

        $this->result = [
            'success' => true,
            'plan_name' => $plan->name,
            'plan_id' => $plan_id,
        ];
    }

    /**
     * Outputs the aggregated JSON response and terminates execution.
     *
     * @return void
     */
    public function displayAjax()
    {
        header('Content-Type: application/json');
        die(Tools::jsonEncode($this->result));
    }
}
