<?php
/**
 * Class MtboricaDeleteRecurringModuleFrontController
 *
 * Deletes a recurring payment plan by id. Enforces admin
 * authentication and returns a JSON response for the admin UI.
 */

class MtboricaDeleteRecurringModuleFrontController extends ModuleFrontController
{
    public $result = array();

    /**
     * Initializes controller and enforces admin authentication.
     *
     * @return void
     */
    public function init()
    {
        parent::init();

        // Check if user is logged in as admin
        $cookie = new Cookie('psAdmin');
        if (!$cookie->id_employee || !$cookie->isLoggedBack()) {
            die(json_encode(array(
                'success' => false,
                'message' => 'You must be logged in as administrator'
            )));
        }
    }

    /**
     * Handles the delete request for a recurring plan.
     *
     * Input: POST `id` (int)
     * Output: JSON `success` and message
     *
     * @return void
     */
    public function initContent()
    {
        parent::initContent();

        if (!Tools::isSubmit('id')) {
            $this->result = array(
                'success' => false,
                'message' => $this->l('Missing ID parameter.')
            );
            return;
        }

        $id = (int) Tools::getValue('id');
        if ($id <= 0) {
            $this->result = array(
                'success' => false,
                'message' => $this->l('Invalid ID parameter.')
            );
            return;
        }

        try {
            require_once _PS_MODULE_DIR_ . 'mtborica/classes/MtboricaRecurring.php';

            $result = MtboricaRecurring::deleteRecurring($id);

            if ($result) {
                $this->result = array(
                    'success' => true,
                    'message' => $this->l('Recurring payment deleted successfully.')
                );
            } else {
                $this->result = array(
                    'success' => false,
                    'message' => $this->l('Failed to delete recurring payment.')
                );
            }
        } catch (Exception $e) {
            $this->result = array(
                'success' => false,
                'message' => $this->l('Error: ') . $e->getMessage()
            );
        }
    }

    /**
     * Outputs the JSON response.
     *
     * @return void
     */
    public function displayAjax()
    {
        header('Content-Type: application/json');
        die(Tools::jsonEncode($this->result));
    }
}
