<?php
require_once _PS_MODULE_DIR_ . 'mtborica/classes/MtboricaOrder.php';
require_once _PS_MODULE_DIR_ . 'mtborica/classes/MtboricaBoricaHelper.php';

use PrestaShop\PrestaShop\Adapter\Presenter\Order\OrderPresenter;

class MtboricaBackModuleFrontController extends ModuleFrontController
{

    public function initContent()
    {
        parent::initContent();

        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            // Set HTTP status code
            http_response_code(405);
            // Assign error context and render error template; stop further processing
            $this->context->smarty->assign([
                'mtborica_back_error' => true,
                'mtborica_back_errors' => [$this->l('Invalid request method. This page only accepts POST requests.')],
            ]);
            $this->setTemplate('module:mtborica/views/templates/front/back.tpl');
            return;
        }
        // Read input parameters
        $borica_action_raw = Tools::getValue('ACTION');
        $borica_rc_raw = Tools::getValue('RC');
        $borica_statusmsg_raw = Tools::getValue('STATUSMSG');
        $borica_terminal_raw = Tools::getValue('TERMINAL');
        $borica_trtype_raw = Tools::getValue('TRTYPE');
        $borica_amount_raw = Tools::getValue('AMOUNT');
        $borica_currency_raw = Tools::getValue('CURRENCY');
        $borica_order_raw = Tools::getValue('ORDER');
        $borica_timestamp_raw = Tools::getValue('TIMESTAMP');
        $borica_approval_raw = Tools::getValue('APPROVAL');
        $borica_rrn_raw = Tools::getValue('RRN');
        $borica_int_ref_raw = Tools::getValue('INT_REF');
        $borica_lang_raw = Tools::getValue('LANG');
        $borica_pares_status_raw = Tools::getValue('PARES_STATUS');
        $borica_cardholderinfo_raw = Tools::getValue('CARDHOLDERINFO');
        $borica_eci_raw = Tools::getValue('ECI');
        $borica_nonce_raw = Tools::getValue('NONCE');
        $borica_p_sign_raw = Tools::getValue('P_SIGN');
        // Basic validations: do not mutate values; only check presence/type
        // ACTION, RC, STATUSMSG, TERMINAL are optional string parameters
        // They will be sanitized with htmlspecialchars() below for safe output

        $borica_trtype_valid = filter_var($borica_trtype_raw, FILTER_VALIDATE_INT);
        $borica_amount_valid = filter_var($borica_amount_raw, FILTER_VALIDATE_FLOAT);

        // All string parameters (CURRENCY, ORDER, TIMESTAMP, TRAN_DATE, APPROVAL, RRN, INT_REF, LANG,
        // PARES_STATUS, AUTH_STEP_RES, ECI, CARD, CARD_BRAND, NONCE, P_SIGN) are optional.
        // They will be sanitized with htmlspecialchars() below for safe output.

        // Prepare safe-to-render values for output only (no mutation for business logic)
        $boricaAction = htmlspecialchars((string) $borica_action_raw, ENT_QUOTES, 'UTF-8');
        $boricaRc = htmlspecialchars((string) $borica_rc_raw, ENT_QUOTES, 'UTF-8');
        $boricaStatusmsg = htmlspecialchars((string) $borica_statusmsg_raw, ENT_QUOTES, 'UTF-8');
        $boricaTerminal = htmlspecialchars((string) $borica_terminal_raw, ENT_QUOTES, 'UTF-8');
        $boricaCurrency = htmlspecialchars((string) $borica_currency_raw, ENT_QUOTES, 'UTF-8');
        $boricaOrder = htmlspecialchars((string) $borica_order_raw, ENT_QUOTES, 'UTF-8');
        $boricaTimestamp = htmlspecialchars((string) $borica_timestamp_raw, ENT_QUOTES, 'UTF-8');
        $boricaApproval = htmlspecialchars((string) $borica_approval_raw, ENT_QUOTES, 'UTF-8');
        $boricaRrn = htmlspecialchars((string) $borica_rrn_raw, ENT_QUOTES, 'UTF-8');
        $boricaIntRef = htmlspecialchars((string) $borica_int_ref_raw, ENT_QUOTES, 'UTF-8');
        $boricaParesStatus = htmlspecialchars((string) $borica_pares_status_raw, ENT_QUOTES, 'UTF-8');
        $boricaCardholderinfo = htmlspecialchars((string) $borica_cardholderinfo_raw, ENT_QUOTES, 'UTF-8');
        $boricaEci = htmlspecialchars((string) $borica_eci_raw, ENT_QUOTES, 'UTF-8');
        $boricaNonce = htmlspecialchars((string) $borica_nonce_raw, ENT_QUOTES, 'UTF-8');
        $boricaPSign = htmlspecialchars((string) $borica_p_sign_raw, ENT_QUOTES, 'UTF-8');
        // Keep TRTYPE and AMOUNT as strings to preserve original format for signature verification
        // The bank sends them as strings and the signature is calculated based on the exact string format
        $boricaTrtype = ($borica_trtype_valid === false) ? '' : (string) $borica_trtype_raw;
        // Keep AMOUNT as string to preserve original format (e.g., "35.00" vs "35") for signature verification
        $boricaAmount = ($borica_amount_valid === false) ? '' : (string) $borica_amount_raw;

        if (1 === (int) Configuration::get('mtborica_debug')) {
            $borica_payment_data = [
                'ACTION' => $borica_action_raw,
                'RC' => $borica_rc_raw,
                'STATUSMSG' => $borica_statusmsg_raw,
                'TERMINAL' => $borica_terminal_raw,
                'TRTYPE' => $borica_trtype_raw,
                'AMOUNT' => $borica_amount_raw,
                'CURRENCY' => $borica_currency_raw,
                'ORDER' => $borica_order_raw,
                'TIMESTAMP' => $borica_timestamp_raw,
                'APPROVAL' => $borica_approval_raw,
                'RRN' => $borica_rrn_raw,
                'INT_REF' => $borica_int_ref_raw,
                'LANG' => $borica_lang_raw,
                'PARES_STATUS' => $borica_pares_status_raw,
                'CARDHOLDERINFO' => $borica_cardholderinfo_raw,
                'ECI' => $borica_eci_raw,
                'NONCE' => $borica_nonce_raw,
                'P_SIGN' => $borica_p_sign_raw,
            ];
            if ((int) $boricaTrtype === Mtborica::BORICA_TRTYPE_RECURRING_DROP_STATUS) {
                MtboricaLogger::logCancelRecurringPaymentReceived($borica_payment_data);
            } else {
                MtboricaLogger::logPaymentReceived($borica_payment_data);
            }
        }

        // Change language based on BORICA LANG parameter
        $boricaLang = strtoupper(trim((string) $borica_lang_raw));
        if (!empty($boricaLang)) {
            $targetIso = 'en';
            if ($boricaLang === 'BG') {
                $targetIso = 'bg';
            } else {
                // Try to respect requested language if it's available
                $requestedIso = strtolower($boricaLang);
                $requestedLangId = Language::getIdByIso($requestedIso);
                if ($requestedLangId) {
                    $targetIso = $requestedIso;
                }
            }

            $langId = Language::getIdByIso($targetIso);
            if ($langId) {
                /** @var Language $language */
                $language = new Language((int) $langId);
                if (Validate::isLoadedObject($language) && $language->active) {
                    // Update context language
                    $this->context->language = $language;
                    // Update cookie to persist language
                    $this->context->cookie->id_lang = (int) $langId;
                    $this->context->cookie->write();
                }
            }
        }

        if (
            '' == $boricaTimestamp ||
            '' == $boricaAction ||
            '' == $boricaRc ||
            '' == $boricaNonce
        ) {
            $this->context->smarty->assign([
                'mtborica_back_error' => true,
                'mtborica_back_errors' => [$this->l('Invalid request parameters. This page only accepts valid request parameters.')],
            ]);
            $this->setTemplate('module:mtborica/views/templates/front/back.tpl');
            return;
        }

        // Continue with normal processing: find order, verify signature, handle status, etc.
        $order_id = null;
        $mtborica_order = MtboricaOrder::getByNonce($boricaNonce);
        if ($mtborica_order && !empty($mtborica_order->increment_id)) {
            $order_id = (int) $mtborica_order->increment_id;
        }

        $order = null;
        $presentedOrder = null;

        if ($order_id) {
            $order = new Order($order_id);
            // For callback, we might not have active session, so check order exists and is valid
            // We can verify order belongs to customer via nonce check instead
            if (Validate::isLoadedObject($order)) {
                $orderCustomerId = $order->id_customer;
                $contextCustomerId = isset($this->context->customer) && $this->context->customer->id ? $this->context->customer->id : null;
                $customerMatch = ($orderCustomerId && $contextCustomerId && $orderCustomerId == $contextCustomerId);

                // If we have customer context and it matches, or if we don't have context (callback scenario)
                // Verify order ownership via the nonce we already checked
                if (!$contextCustomerId || $customerMatch) {
                    // Use OrderPresenter to format order data for template (same as OrderConfirmationController)
                    try {
                        $order_presenter = new OrderPresenter();
                        $presentedOrder = $order_presenter->present($order);
                    } catch (Exception $e) {
                        // Silently fail and continue
                        $presentedOrder = null;
                    }
                } else {
                    // Customer mismatch - set order to null for security
                    $order = null;
                }
            }
        }

        // Use current timestamp if boricaTimestamp is empty or invalid
        $timestampValue = !empty($boricaTimestamp) ? strtotime($boricaTimestamp) : time();
        $createdAt = ($timestampValue !== false) ? date('Y-m-d H:i:s', $timestampValue) : date('Y-m-d H:i:s');
        $dataBoricaOrder = [
            'action' => $boricaAction,
            'rc' => $boricaRc,
            'created_at' => $createdAt,
            'status' => $boricaStatusmsg,
            'rrn' => $boricaRrn,
            'int_ref' => $boricaIntRef,
            'approval' => $boricaApproval,
            'nonce' => $boricaNonce
        ];
        MtboricaOrder::updateBoricaOrder($dataBoricaOrder);

        $orderRow = MtboricaOrder::getByNonce($boricaNonce);
        $borica_order_reccur_id = '';
        if ($orderRow && !empty($orderRow->recur_id)) {
            $borica_order_reccur_id = $orderRow->recur_id;
        }

        $paymentSuccess = false;
        $checkAuthorization = false;
        // Handle recurring drop status
        if ((int) $boricaTrtype === Mtborica::BORICA_TRTYPE_RECURRING_DROP_STATUS) {
            // Verify signature first
            $checkAuthorization = MtboricaBoricaHelper::checkAuthorization(
                $boricaPSign,
                $boricaAction,
                $boricaRc,
                $boricaApproval,
                $boricaTerminal,
                $boricaTrtype,
                $boricaAmount,
                $boricaCurrency,
                $boricaOrder,
                $boricaRrn,
                $boricaIntRef,
                $boricaParesStatus,
                $boricaEci,
                $boricaTimestamp,
                $boricaNonce
            );

            if ($checkAuthorization && $boricaRc == '00') {
                // Successful cancellation
                $cancelled_status_id = (int) Configuration::get('mtborica_order_status_recurring_cancelled');
                if ($order_id && $cancelled_status_id > 0 && Validate::isLoadedObject($order)) {
                    $history = new OrderHistory();
                    $history->id_order = (int) $order_id;
                    $history->changeIdOrderState($cancelled_status_id, $order, true);
                    $history->addWithemail(true);
                }

                $paymentSuccess = true;
            }
        }

        if ((int) $boricaTrtype === Mtborica::BORICA_TRTYPE_AUTHORIZATION) {
            // Determine payment status
            if ($boricaAction == 0 && $boricaRc == '00') {
                $ok_status_id = Configuration::get('mtborica_order_status_id');
                $recurring_status_id = Configuration::get('mtborica_order_status_recurring');
                if ($borica_order_reccur_id) {
                    $ok_status_id = $recurring_status_id;
                }
                if ($order_id && $ok_status_id && Validate::isLoadedObject($order)) {
                    $history = new OrderHistory();
                    $history->id_order = (int) $order_id;
                    $history->changeIdOrderState((int) $ok_status_id, $order, true);
                    $history->addWithemail(true);
                }
                $paymentSuccess = true;

                $checkAuthorization = MtboricaBoricaHelper::checkAuthorization(
                    $boricaPSign,
                    $boricaAction,
                    $boricaRc,
                    $boricaApproval,
                    $boricaTerminal,
                    $boricaTrtype,
                    $boricaAmount,
                    $boricaCurrency,
                    $boricaOrder,
                    $boricaRrn,
                    $boricaIntRef,
                    $boricaParesStatus,
                    $boricaEci,
                    $boricaTimestamp,
                    $boricaNonce
                );
            } else {
                $not_status_id = Configuration::get('mtborica_order_status_not_id');
                $recurring_status_id = Configuration::get('mtborica_order_status_recurring_cancelled');
                if ($borica_order_reccur_id) {
                    $not_status_id = $recurring_status_id;
                }
                if ($order_id && $not_status_id && Validate::isLoadedObject($order)) {
                    $history = new OrderHistory();
                    $history->id_order = (int) $order_id;
                    $history->changeIdOrderState((int) $not_status_id, $order, true);
                    $history->addWithemail(true);
                }
            }
        }

        // Assign template variables
        $isRecurringDrop = ((int) $boricaTrtype === Mtborica::BORICA_TRTYPE_RECURRING_DROP_STATUS);
        $successMessage = $isRecurringDrop
            ? $this->l('Your recurring payment subscription plan has been successfully canceled.')
            : Configuration::get('mtborica_success_message');
        $templateVars = [
            'paymentSuccess' => $paymentSuccess,
            'checkAuthorization' => $checkAuthorization,
            'boricaUnsuccessMessage' => Configuration::get('mtborica_unsuccess_message'),
            'boricaSuccessMessage' => $successMessage,
            'boricaOrder' => $orderRow ? $orderRow->increment_id : null,
            'boricaCardholderinfo' => $boricaCardholderinfo,
            'baseUrl' => $this->context->link->getPageLink('index', true),
            'payment_method_name' => $isRecurringDrop
                ? $this->l('Recurring Plan Cancellation')
                : ($borica_order_reccur_id ? $this->l('Recurring Payment by Credit/Debit Card - Payment by Credit/Debit Card.') : $this->getPaymentMethodName()),
            'boricaTestMode' => (int) Configuration::get('mtborica_testmode'),
            'isRecurringDrop' => $isRecurringDrop,
        ];

        $register_form = $this
            ->makeCustomerForm()
            ->setGuestAllowed(false)
            ->fillWith(Tools::getAllValues());
        $templateVars['register_form'] = $register_form;
        // Add presented order data for template (contains formatted order with products, subtotals, etc.)
        $templateVars['order'] = $presentedOrder;
        // Also add customer data if needed
        if ($this->context->customer->id) {
            $templateVars['customer'] = $this->context->customer;
        }

        $this->context->smarty->assign($templateVars);
        $this->setTemplate('module:mtborica/views/templates/front/back.tpl');
    }

    private function getPaymentMethodName()
    {
        return !empty($this->module->description)
            ? $this->module->description
            : (!empty($this->module->displayName) ? $this->module->displayName : $this->l('Payment by Credit/Debit Card'));
    }
}
